/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.CheckBoxEditor;
import com.bc.ceres.swing.binding.internal.NumericEditor;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import junit.framework.TestCase;

public class ValueEditorRegistryTest
extends TestCase {
    private PropertyEditorRegistry editorRegistry;

    protected void setUp() throws Exception {
        this.editorRegistry = PropertyEditorRegistry.getInstance();
    }

    public void testGetValueEditor_notExistant() throws Exception {
        PropertyEditor propertyEditor = this.editorRegistry.getPropertyEditor("foo");
        ValueEditorRegistryTest.assertNull((Object)propertyEditor);
    }

    public void testGetValueEditor_TextField() throws Exception {
        PropertyEditor propertyEditor = this.editorRegistry.getPropertyEditor(TextFieldEditor.class.getName());
        ValueEditorRegistryTest.assertNotNull((Object)propertyEditor);
        ValueEditorRegistryTest.assertSame(TextFieldEditor.class, propertyEditor.getClass());
    }

    public void testFindValueEditor_Null() throws Exception {
        try {
            this.editorRegistry.findPropertyEditor(null);
            ValueEditorRegistryTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testFindValueEditor_UnknownEditor() throws Exception {
        PropertyDescriptor descriptor = new PropertyDescriptor("test", TestCase.class);
        PropertyEditor propertyEditor = this.editorRegistry.findPropertyEditor(descriptor);
        ValueEditorRegistryTest.assertNotNull((Object)propertyEditor);
        ValueEditorRegistryTest.assertSame(TextFieldEditor.class, propertyEditor.getClass());
    }

    public void testFindValueEditor_SpecifiedEditor() throws Exception {
        PropertyDescriptor descriptor = new PropertyDescriptor("test", Double.class);
        CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
        descriptor.setAttribute("propertyEditor", (Object)checkBoxEditor);
        PropertyEditor propertyEditor = this.editorRegistry.findPropertyEditor(descriptor);
        ValueEditorRegistryTest.assertNotNull((Object)propertyEditor);
        ValueEditorRegistryTest.assertSame((Object)checkBoxEditor, (Object)propertyEditor);
    }

    public void testFindValueEditor_MatchingEditor() throws Exception {
        PropertyDescriptor descriptor = new PropertyDescriptor("test", Double.class);
        PropertyEditor propertyEditor = this.editorRegistry.findPropertyEditor(descriptor);
        ValueEditorRegistryTest.assertNotNull((Object)propertyEditor);
        ValueEditorRegistryTest.assertSame(NumericEditor.class, propertyEditor.getClass());
    }
}

