/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.BindingProblem;
import com.bc.ceres.swing.binding.BindingProblemListener;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BindingContextTest {
    private BindingContext bindingContextVB;
    private PropertyContainer propertyContainerVB;
    private PropertyContainer propertyContainerOB;
    private BindingContext bindingContextOB;
    private TestPojo pojo;
    private Exception error;
    private JComponent component;

    @Before
    public void setUp() throws Exception {
        this.propertyContainerVB = PropertyContainer.createValueBacked(TestPojo.class);
        this.propertyContainerVB.getDescriptor("valueSetBoundIntValue").setValueSet(new ValueSet((Object[])TestPojo.intValueSet));
        this.bindingContextVB = new BindingContext((PropertySet)this.propertyContainerVB, null);
        this.bindingContextVB.addProblemListener((BindingProblemListener)new MyBindingProblemListener());
        this.pojo = new TestPojo();
        this.propertyContainerOB = PropertyContainer.createObjectBacked((Object)this.pojo);
        this.propertyContainerOB.getDescriptor("valueSetBoundIntValue").setValueSet(new ValueSet((Object[])TestPojo.intValueSet));
        this.bindingContextOB = new BindingContext((PropertySet)this.propertyContainerOB, null);
        this.bindingContextVB.addProblemListener((BindingProblemListener)new MyBindingProblemListener());
        this.error = null;
        this.component = null;
    }

    private void clearError() {
        this.error = null;
        this.component = null;
    }

    @Test
    public void testBindSpinner() throws ValidationException {
        JSpinner spinner = new JSpinner();
        Binding binding = this.bindingContextVB.bind("intValue", spinner);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)spinner, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"intValue", (Object)spinner.getName());
        spinner.setValue(3);
        Assert.assertEquals((long)3L, (long)((Integer)this.propertyContainerVB.getValue("intValue")).intValue());
        this.propertyContainerVB.setValue("intValue", (Object)76);
        Assert.assertEquals((Object)76, (Object)spinner.getValue());
    }

    @Test
    public void testBindComboBox() throws ValidationException {
        JComboBox<Integer> comboBox = new JComboBox<Integer>(new Integer[]{1, 3, 7});
        comboBox.setEditable(false);
        Binding binding = this.bindingContextVB.bind("intValue", comboBox);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame(comboBox, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"intValue", (Object)comboBox.getName());
        comboBox.setSelectedItem(3);
        Assert.assertEquals((Object)3, (Object)comboBox.getSelectedItem());
        Assert.assertEquals((Object)3, (Object)binding.getPropertyValue());
        this.propertyContainerVB.setValue("intValue", (Object)1);
        Assert.assertEquals((Object)1, (Object)comboBox.getSelectedItem());
        Assert.assertEquals((Object)1, (Object)binding.getPropertyValue());
        comboBox.setSelectedItem(4);
        Assert.assertEquals((Object)1, (Object)comboBox.getSelectedItem());
        Assert.assertEquals((Object)1, (Object)binding.getPropertyValue());
        comboBox.setEditable(true);
        comboBox.setSelectedItem(4);
        Assert.assertEquals((Object)4, (Object)comboBox.getSelectedItem());
        Assert.assertEquals((Object)4, (Object)binding.getPropertyValue());
        this.propertyContainerVB.setValue("intValue", (Object)5);
        Assert.assertEquals((Object)5, (Object)comboBox.getSelectedItem());
        Assert.assertEquals((Object)5, (Object)binding.getPropertyValue());
        comboBox.setEditable(false);
        ValueSet valueSet = new ValueSet(new Object[]{10, 20});
        PropertyDescriptor descriptor = binding.getContext().getPropertySet().getDescriptor("intValue");
        descriptor.setValueSet(valueSet);
        Assert.assertEquals((long)2L, (long)comboBox.getModel().getSize());
        Assert.assertEquals((long)10L, (long)((Integer)comboBox.getModel().getElementAt(0)).intValue());
        Assert.assertEquals((long)20L, (long)((Integer)comboBox.getModel().getElementAt(1)).intValue());
        Assert.assertEquals((Object)10, (Object)comboBox.getSelectedItem());
        Assert.assertEquals((Object)10, (Object)binding.getPropertyValue());
        Assert.assertNull((Object)binding.getProblem());
    }

    @Test
    public void testBindTextField() throws Exception {
        JTextField textField = new JTextField();
        Binding binding = this.bindingContextVB.bind("stringValue", textField);
        Thread.sleep(1000L);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)textField, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"stringValue", (Object)textField.getName());
        textField.setText("Bibo");
        textField.postActionEvent();
        Assert.assertEquals((Object)"Bibo", (Object)this.propertyContainerVB.getValue("stringValue"));
        this.propertyContainerVB.setValue("stringValue", (Object)"Samson");
        Thread.sleep(1000L);
        Assert.assertEquals((Object)"Samson", (Object)textField.getText());
    }

    @Ignore(value="fails often on the server")
    public void testBindTextField2() throws Exception {
        JTextField textField = new JTextField();
        Binding binding = this.bindingContextOB.bind("stringValue", textField);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)textField, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"stringValue", (Object)textField.getName());
        textField.setText("Bibo");
        textField.postActionEvent();
        Thread.sleep(100L);
        Assert.assertEquals((Object)"Bibo", (Object)this.propertyContainerOB.getValue("stringValue"));
        this.propertyContainerOB.setValue("stringValue", (Object)"Samson");
        Thread.sleep(100L);
        Assert.assertEquals((Object)"Samson", (Object)this.pojo.stringValue);
        Assert.assertEquals((Object)"Samson", (Object)textField.getText());
        this.pojo.stringValue = "Oscar";
        Assert.assertSame((Object)"Oscar", (Object)this.propertyContainerOB.getValue("stringValue"));
        Assert.assertNotSame((Object)"Oscar", (Object)textField.getText());
    }

    @Test
    public void testBindFormattedTextFieldToString() throws ValidationException {
        JFormattedTextField textField = new JFormattedTextField();
        Binding binding = this.bindingContextVB.bind("stringValue", textField);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)textField, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"stringValue", (Object)textField.getName());
        textField.setValue("Bibo");
        Assert.assertEquals((Object)"Bibo", (Object)this.propertyContainerVB.getValue("stringValue"));
        this.propertyContainerVB.setValue("stringValue", (Object)"Samson");
        Assert.assertEquals((Object)"Samson", (Object)textField.getValue());
    }

    @Test
    public void testBindFormattedTextFieldToDouble() throws ValidationException {
        JFormattedTextField textField = new JFormattedTextField();
        Binding binding = this.bindingContextVB.bind("doubleValue", textField);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)textField, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"doubleValue", (Object)textField.getName());
        textField.setValue(3.14);
        Assert.assertEquals((double)3.14, (double)((Double)this.propertyContainerVB.getValue("doubleValue")), (double)1.0E-6);
        this.propertyContainerVB.setValue("doubleValue", (Object)2.71);
        Assert.assertEquals((Object)2.71, (Object)textField.getValue());
    }

    @Test
    public void testBindTextArea() throws Exception {
        JTextArea textArea = new JTextArea();
        TextComponentAdapter textComponentAdapter = new TextComponentAdapter((JTextComponent)textArea);
        Binding binding = this.bindingContextVB.bind("stringValue", (ComponentAdapter)textComponentAdapter);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)textArea, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"stringValue", (Object)textArea.getName());
        textArea.setText("Bibo");
        textComponentAdapter.actionPerformed(null);
        Assert.assertEquals((Object)"Bibo", (Object)this.propertyContainerVB.getValue("stringValue"));
        this.propertyContainerVB.setValue("stringValue", (Object)"Samson");
        Thread.sleep(100L);
        Assert.assertEquals((Object)"Samson", (Object)textArea.getText());
    }

    @Test
    public void testBindCheckBox() throws ValidationException {
        JCheckBox checkBox = new JCheckBox();
        Binding binding = this.bindingContextVB.bind("booleanValue", checkBox);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)checkBox, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"booleanValue", (Object)checkBox.getName());
        checkBox.doClick();
        Assert.assertEquals((Object)true, (Object)this.propertyContainerVB.getValue("booleanValue"));
        this.propertyContainerVB.setValue("booleanValue", (Object)false);
        Assert.assertEquals((Object)false, (Object)checkBox.isSelected());
    }

    @Test
    public void testBindRadioButton() throws ValidationException {
        JRadioButton radioButton = new JRadioButton();
        Binding binding = this.bindingContextVB.bind("booleanValue", radioButton);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)radioButton, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"booleanValue", (Object)radioButton.getName());
        radioButton.doClick();
        Assert.assertEquals((Object)true, (Object)this.propertyContainerVB.getValue("booleanValue"));
        this.propertyContainerVB.setValue("booleanValue", (Object)false);
        Assert.assertEquals((Object)false, (Object)radioButton.isSelected());
    }

    @Test
    public void testBindButtonGroup() throws ValidationException {
        JRadioButton radioButton1 = new JRadioButton();
        JRadioButton radioButton2 = new JRadioButton();
        JRadioButton radioButton3 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton1);
        buttonGroup.add(radioButton2);
        buttonGroup.add(radioButton3);
        Property m = this.propertyContainerVB.getProperty("valueSetBoundIntValue");
        m.setValue((Object)TestPojo.intValueSet[0]);
        Binding binding = this.bindingContextVB.bind("valueSetBoundIntValue", buttonGroup);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame((Object)radioButton1, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)3L, (long)binding.getComponents().length);
        Assert.assertSame((Object)radioButton1, (Object)binding.getComponents()[0]);
        Assert.assertSame((Object)radioButton2, (Object)binding.getComponents()[1]);
        Assert.assertSame((Object)radioButton3, (Object)binding.getComponents()[2]);
        Assert.assertEquals((Object)true, (Object)radioButton1.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton2.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton3.isSelected());
        Assert.assertEquals((Object)TestPojo.intValueSet[0], (Object)m.getValue());
        radioButton3.doClick();
        Assert.assertEquals((Object)false, (Object)radioButton1.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton2.isSelected());
        Assert.assertEquals((Object)true, (Object)radioButton3.isSelected());
        Assert.assertEquals((Object)TestPojo.intValueSet[2], (Object)m.getValue());
        radioButton2.doClick();
        Assert.assertEquals((Object)false, (Object)radioButton1.isSelected());
        Assert.assertEquals((Object)true, (Object)radioButton2.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton3.isSelected());
        Assert.assertEquals((Object)TestPojo.intValueSet[1], (Object)m.getValue());
        m.setValue((Object)TestPojo.intValueSet[0]);
        Assert.assertEquals((Object)true, (Object)radioButton1.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton2.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton3.isSelected());
        Assert.assertEquals((Object)TestPojo.intValueSet[0], (Object)m.getValue());
        m.setValue((Object)TestPojo.intValueSet[2]);
        Assert.assertEquals((Object)false, (Object)radioButton1.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton2.isSelected());
        Assert.assertEquals((Object)true, (Object)radioButton3.isSelected());
        Assert.assertEquals((Object)TestPojo.intValueSet[2], (Object)m.getValue());
        m.setValue((Object)TestPojo.intValueSet[1]);
        Assert.assertEquals((Object)false, (Object)radioButton1.isSelected());
        Assert.assertEquals((Object)true, (Object)radioButton2.isSelected());
        Assert.assertEquals((Object)false, (Object)radioButton3.isSelected());
        Assert.assertEquals((Object)TestPojo.intValueSet[1], (Object)m.getValue());
    }

    @Test
    public void testBindListSelection() throws ValidationException {
        JList<Integer> list = new JList<Integer>(new Integer[]{3, 4, 5, 6, 7});
        Binding binding = this.bindingContextVB.bind("listValue", list, true);
        Assert.assertNotNull((Object)binding);
        Assert.assertSame(list, (Object)BindingContextTest.getPrimaryComponent(binding));
        Assert.assertNotNull((Object)binding.getComponents());
        Assert.assertEquals((long)1L, (long)binding.getComponents().length);
        Assert.assertEquals((Object)"listValue", (Object)list.getName());
        list.setSelectedIndex(2);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{5}, (int[])this.propertyContainerVB.getValue("listValue")));
        this.propertyContainerVB.setValue("listValue", (Object)new int[]{6});
        Assert.assertEquals((long)6L, (long)list.getSelectedValue().intValue());
    }

    @Ignore(value="fails often on the server")
    public void testAdjustComponents() throws Exception {
        JTextField textField1 = new JTextField();
        JTextField textField2 = new JTextField();
        JCheckBox checkBox = new JCheckBox();
        this.pojo.booleanValue = true;
        this.pojo.doubleValue = 3.2;
        this.pojo.stringValue = "ABC";
        this.bindingContextOB.bind("booleanValue", checkBox);
        this.bindingContextOB.bind("doubleValue", textField1);
        this.bindingContextOB.bind("stringValue", textField2);
        Thread.sleep(100L);
        Assert.assertEquals((Object)true, (Object)checkBox.isSelected());
        Assert.assertEquals((Object)"3.2", (Object)textField1.getText());
        Assert.assertEquals((Object)"ABC", (Object)textField2.getText());
        this.pojo.booleanValue = false;
        this.pojo.doubleValue = 1.5;
        this.pojo.stringValue = "XYZ";
        Assert.assertEquals((Object)true, (Object)checkBox.isSelected());
        Assert.assertEquals((Object)"3.2", (Object)textField1.getText());
        Assert.assertEquals((Object)"ABC", (Object)textField2.getText());
        this.bindingContextOB.adjustComponents();
        Thread.sleep(100L);
        Assert.assertEquals((Object)false, (Object)checkBox.isSelected());
        Assert.assertEquals((Object)"1.5", (Object)textField1.getText());
        Assert.assertEquals((Object)"XYZ", (Object)textField2.getText());
    }

    @Test
    public void testSecondaryComponent() throws Exception {
        JTextField textField = new JTextField();
        Binding binding = this.bindingContextVB.bind("stringValue", textField);
        JLabel label = new JLabel("myLabel");
        binding.addComponent((JComponent)label);
        JComponent[] components = binding.getComponents();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)2L, (long)components.length);
        Assert.assertSame((Object)BindingContextTest.getPrimaryComponent(binding), (Object)components[0]);
        Assert.assertSame((Object)label, (Object)components[1]);
    }

    @Test
    public void testProblemManagement() {
        JTextField intTextField = new JTextField();
        JTextField stringTextField = new JTextField();
        MyChangeListener listener = new MyChangeListener();
        this.clearError();
        this.bindingContextVB.addProblemListener((BindingProblemListener)listener);
        this.bindingContextVB.addPropertyChangeListener((PropertyChangeListener)listener);
        this.bindingContextVB.bind("intValue", intTextField);
        this.bindingContextVB.bind("stringValue", stringTextField);
        Assert.assertEquals((Object)"", (Object)listener.trace);
        Assert.assertEquals((Object)false, (Object)this.bindingContextVB.hasProblems());
        Assert.assertNotNull((Object)this.bindingContextVB.getProblems());
        Assert.assertEquals((long)0L, (long)this.bindingContextVB.getProblems().length);
        Assert.assertNull((Object)this.error);
        Assert.assertNull((Object)this.component);
        this.clearError();
        this.bindingContextVB.getBinding("intValue").setPropertyValue((Object)"a");
        Assert.assertEquals((Object)"P;", (Object)listener.trace);
        Assert.assertEquals((Object)true, (Object)this.bindingContextVB.hasProblems());
        Assert.assertNotNull((Object)this.bindingContextVB.getProblems());
        Assert.assertEquals((long)1L, (long)this.bindingContextVB.getProblems().length);
        Assert.assertNotNull((Object)this.error);
        Assert.assertSame((Object)intTextField, (Object)this.component);
        this.clearError();
        this.bindingContextVB.getBinding("stringValue").setPropertyValue((Object)5);
        Assert.assertEquals((Object)"P;P;", (Object)listener.trace);
        Assert.assertEquals((Object)true, (Object)this.bindingContextVB.hasProblems());
        Assert.assertNotNull((Object)this.bindingContextVB.getProblems());
        Assert.assertEquals((long)2L, (long)this.bindingContextVB.getProblems().length);
        Assert.assertNotNull((Object)this.error);
        Assert.assertSame((Object)stringTextField, (Object)this.component);
        this.clearError();
        this.bindingContextVB.getBinding("intValue").setPropertyValue((Object)5);
        Assert.assertEquals((Object)"P;P;V;C;", (Object)listener.trace);
        Assert.assertEquals((Object)true, (Object)this.bindingContextVB.hasProblems());
        Assert.assertNotNull((Object)this.bindingContextVB.getProblems());
        Assert.assertEquals((long)1L, (long)this.bindingContextVB.getProblems().length);
        Assert.assertNull((Object)this.error);
        Assert.assertNull((Object)this.component);
        this.clearError();
        this.bindingContextVB.getBinding("stringValue").setPropertyValue((Object)"a");
        Assert.assertEquals((Object)"P;P;V;C;V;C;", (Object)listener.trace);
        Assert.assertEquals((Object)false, (Object)this.bindingContextVB.hasProblems());
        Assert.assertNotNull((Object)this.bindingContextVB.getProblems());
        Assert.assertEquals((long)0L, (long)this.bindingContextVB.getProblems().length);
        Assert.assertNull((Object)this.error);
        Assert.assertNull((Object)this.component);
    }

    private static JComponent getPrimaryComponent(Binding binding) {
        return binding.getComponents()[0];
    }

    private class MyBindingProblemListener
    implements BindingProblemListener {
        private MyBindingProblemListener() {
        }

        public void problemReported(BindingProblem newProblem, BindingProblem oldProblem) {
            BindingContextTest.this.error = (Exception)newProblem.getCause();
            BindingContextTest.this.component = newProblem.getBinding().getComponents()[0];
        }

        public void problemCleared(BindingProblem oldProblem) {
            BindingContextTest.this.error = null;
            BindingContextTest.this.component = null;
        }
    }

    private static class MyChangeListener
    implements BindingProblemListener,
    PropertyChangeListener {
        String trace = "";

        private MyChangeListener() {
        }

        public void problemReported(BindingProblem newProblem, BindingProblem oldProblem) {
            this.trace = this.trace + "P;";
        }

        public void problemCleared(BindingProblem oldProblem) {
            this.trace = this.trace + "C;";
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.trace = this.trace + "V;";
        }
    }

    private static class TestPojo {
        boolean booleanValue;
        int intValue;
        double doubleValue;
        String stringValue;
        int[] listValue;
        int valueSetBoundIntValue;
        static Integer[] intValueSet = new Integer[]{101, 102, 103};

        private TestPojo() {
        }
    }
}

