/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.junit.Assert;
import org.junit.Test;

public class TableLayoutTest {
    @Test
    public void testCoolnessOfTableLayout() {
        TableLayout layout = new TableLayout(3);
        Assert.assertEquals((long)3L, (long)layout.getColumnCount());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TableLayoutTest.showFrame(TableLayoutTest.createPanel1());
        TableLayoutTest.showFrame(TableLayoutTest.createPanel2());
    }

    private static JPanel createPanel1() {
        TableLayout layout = new TableLayout(3);
        layout.setTableAnchor(TableLayout.Anchor.LINE_START);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(2, 2);
        layout.setColumnWeightX(0, Double.valueOf(0.1));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setColumnWeightX(2, Double.valueOf(0.1));
        layout.setCellColspan(2, 0, Integer.valueOf(3));
        layout.setCellColspan(3, 0, Integer.valueOf(3));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add(new JLabel("Wavelength:"));
        panel.add(new JTextField(16));
        panel.add(new JLabel("nm"));
        panel.add(new JLabel("Bandwidth:"));
        panel.add(new JTextField(16));
        panel.add(new JLabel("nm"));
        panel.add(new JCheckBox("Use no-data value"));
        panel.add(new JCheckBox("Use expression whenever it make sense"));
        System.out.println("layout = " + layout);
        return panel;
    }

    private static JPanel createPanel2() {
        TableLayout layout = new TableLayout(2);
        layout.setTableAnchor(TableLayout.Anchor.LINE_START);
        layout.setRowFill(0, TableLayout.Fill.BOTH);
        layout.setRowFill(1, TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(2, 2);
        layout.setColumnWeightX(0, Double.valueOf(0.5));
        layout.setColumnWeightX(1, Double.valueOf(0.5));
        layout.setRowWeightX(0, Double.valueOf(1.0));
        layout.setRowWeightY(0, Double.valueOf(1.0));
        layout.setRowWeightY(1, Double.valueOf(0.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add(new JScrollPane(new JList<Object>(new Object[]{"Ernie", "Bibo", "Bert"})));
        panel.add(new JScrollPane(new JList<Object>(new Object[]{"Ernie", "Bibo", "Bert"})));
        JButton comp = new JButton("Start");
        comp.setMinimumSize(null);
        comp.setMaximumSize(null);
        comp.setPreferredSize(null);
        JPanel p = new JPanel();
        p.add(comp);
        panel.add(p);
        System.out.println("layout = " + layout);
        return panel;
    }

    private static void showFrame(JPanel panel) {
        JFrame frame = new JFrame(TableLayoutTest.class.getName());
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

