/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.Grid;
import com.bc.ceres.swing.ListControlBar;
import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GridGuiTest2 {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame(Grid.class.getSimpleName());
        frame.getContentPane().add((Component)GridGuiTest2.createGridPanel(), "Center");
        frame.setDefaultCloseOperation(3);
        frame.setSize(340, 340);
        frame.setVisible(true);
    }

    static JPanel createGridPanel() {
        final Grid grid = new Grid(6, false);
        grid.getLayout().setTablePadding(4, 3);
        grid.getLayout().setTableAnchor(TableLayout.Anchor.BASELINE);
        grid.getLayout().setTableAnchor(TableLayout.Anchor.NORTHWEST);
        grid.getLayout().setColumnFill(2, TableLayout.Fill.HORIZONTAL);
        grid.getLayout().setColumnFill(3, TableLayout.Fill.HORIZONTAL);
        grid.getLayout().setColumnFill(4, TableLayout.Fill.HORIZONTAL);
        grid.getLayout().setColumnWeightX(2, Double.valueOf(1.0));
        grid.getLayout().setColumnWeightX(3, Double.valueOf(1.0));
        grid.getLayout().setColumnWeightX(4, Double.valueOf(1.0));
        grid.setHeaderRow(new JComponent[]{new JLabel("<html><b>Agg.</b>"), new JLabel("<html><b>Source</b>"), new JLabel("<html><b>Targets</b>"), new JLabel("<html><b>Parameters</b>"), null});
        ListControlBar gridControlBar = ListControlBar.create((int)0, (Grid)grid, (ListControlBar.ListController)new GridController(grid), (String[])new String[0]);
        final JCheckBox sel = new JCheckBox();
        sel.setToolTipText("Show/hide selection column");
        sel.setBorderPaintedFlat(true);
        sel.setBorderPainted(false);
        sel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                grid.setShowSelectionColumn(sel.isSelected());
            }
        });
        gridControlBar.add((Component)sel, 0);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)new JScrollPane((Component)grid), "Center");
        panel.add((Component)gridControlBar, "South");
        return panel;
    }

    private static int random(int n) {
        return (int)(Math.random() * (double)n);
    }

    public static String genNames(int n, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(GridGuiTest2.genName());
        }
        return sb.toString();
    }

    public static String genName() {
        int n = 3 + GridGuiTest2.random(8);
        char[] str = new char[n];
        char[] voc = new char[]{'a', 'a', 'a', 'e', 'e', 'e', 'e', 'e', 'i', 'i', 'o', 'o', 'u', 'u', 'y'};
        for (int i = 0; i < str.length; ++i) {
            str[i] = i % 2 == 0 ? voc[GridGuiTest2.random(voc.length)] : (char)(97 + (int)(25.0 * Math.random()));
        }
        str[0] = Character.toUpperCase(str[0]);
        return new String(str);
    }

    static class GridController
    extends ListControlBar.AbstractListController {
        final Grid grid;

        private GridController(Grid grid) {
            this.grid = grid;
        }

        public boolean addRow(int index) {
            String[] AGGS = new String[]{"AVG", "AVG_ML", "PERCENTILE", "ON_MAX_SET", "MIN_MAX_SET", "COUNT"};
            int n = AGGS.length;
            final JButton button = new JButton("...");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowIndex = grid.findDataRowIndex((JComponent)button);
                    JOptionPane.showMessageDialog((Component)grid, "Editing row #" + rowIndex);
                }
            });
            this.grid.addDataRow(new JComponent[]{new JLabel("<html><b>" + AGGS[GridGuiTest2.random(n)] + "</b>"), new JLabel("<html>" + GridGuiTest2.genName()), new JLabel("<html>" + GridGuiTest2.genNames(1 + GridGuiTest2.random(2), "<br/>")), new JLabel("<html>" + GridGuiTest2.genNames(1 + GridGuiTest2.random(3), "<br/>")), button});
            return true;
        }

        public boolean removeRows(int[] indices) {
            this.grid.removeDataRows(indices);
            return true;
        }

        public boolean moveRowUp(int index) {
            this.grid.moveDataRowUp(index);
            return true;
        }

        public boolean moveRowDown(int index) {
            this.grid.moveDataRowDown(index);
            return true;
        }
    }
}

