/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.PointFigure;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.DefaultPointFigure;
import com.bc.ceres.swing.figure.support.DefaultShapeFigure;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class DefaultFigureFactory
implements FigureFactory {
    @Override
    public PointFigure createPointFigure(Point2D geometry, FigureStyle style) {
        return new DefaultPointFigure(geometry, 1.0E-10, style, this.deriveSelectedStyle(style));
    }

    @Override
    public ShapeFigure createLineFigure(Shape geometry, FigureStyle style) {
        return new DefaultShapeFigure(geometry, Figure.Rank.LINE, style, this.deriveSelectedStyle(style));
    }

    @Override
    public ShapeFigure createPolygonFigure(Shape geometry, FigureStyle style) {
        return new DefaultShapeFigure(geometry, Figure.Rank.AREA, style, this.deriveSelectedStyle(style));
    }

    public FigureStyle deriveSelectedStyle(FigureStyle style) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle();
        figureStyle.setFillColor(style.getFillColor());
        figureStyle.setFillOpacity(style.getFillOpacity());
        figureStyle.setStrokeColor(Color.YELLOW);
        figureStyle.setStrokeOpacity(0.9);
        figureStyle.setStrokeWidth(style.getStrokeWidth() + 1.0);
        figureStyle.setSymbolName(style.getSymbolName());
        figureStyle.setSymbolName(style.getSymbolImagePath());
        figureStyle.setSymbolRefX(style.getSymbolRefX());
        figureStyle.setSymbolRefY(style.getSymbolRefY());
        return figureStyle;
    }
}

