/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.AbstractFigure;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultFigureCollection
extends AbstractFigure
implements FigureCollection {
    private List<Figure> figureList;
    private Set<Figure> figureSet;
    private Rectangle2D bounds;
    private ChangeDelegate changeDelegate;

    public DefaultFigureCollection() {
        this(NO_FIGURES);
    }

    public DefaultFigureCollection(Figure[] figures) {
        List<Figure> list = Arrays.asList(figures);
        this.init(list);
    }

    private synchronized void init(List<Figure> list) {
        this.setNormalStyle(new DefaultFigureStyle());
        this.setSelectedStyle(new DefaultFigureStyle());
        this.figureList = new ArrayList<Figure>(list);
        this.figureSet = new HashSet<Figure>(list);
        this.changeDelegate = new ChangeDelegate();
        for (Figure figure : this.figureList) {
            figure.addChangeListener(this.changeDelegate);
        }
        this.addChangeListener(new BoundsUpdater());
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isSelected() {
        if (this.getFigureCount() == 0) {
            return false;
        }
        for (Figure figure : this.getFigures()) {
            if (figure.isSelected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.isSelectable()) {
            for (Figure figure : this.getFigures()) {
                if (!figure.isSelectable()) continue;
                figure.setSelected(selected);
            }
        }
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public Figure.Rank getRank() {
        return Figure.Rank.NOT_SPECIFIED;
    }

    @Override
    public synchronized void dispose() {
        this.removeFiguresImpl();
        super.dispose();
    }

    @Override
    public synchronized Object clone() {
        DefaultFigureCollection figureCollection = (DefaultFigureCollection)super.clone();
        figureCollection.init(this.figureList);
        return figureCollection;
    }

    @Override
    public int getMaxSelectionStage() {
        return 1;
    }

    @Override
    public synchronized Handle[] createHandles(int selectionStage) {
        if (this.getFigureCount() == 0) {
            return NO_HANDLES;
        }
        if (this.getFigureCount() == 1) {
            return this.getFigure(0).createHandles(selectionStage);
        }
        return this.createScaleHandles(0.0);
    }

    @Override
    public boolean isCloseTo(Point2D point, AffineTransform m2v) {
        return this.getBounds().contains(point);
    }

    @Override
    public synchronized boolean contains(Figure figure) {
        return this.figureSet.contains(figure);
    }

    @Override
    public synchronized int getFigureCount() {
        return this.figureList.size();
    }

    @Override
    public synchronized int getFigureIndex(Figure figure) {
        return this.figureList.indexOf(figure);
    }

    @Override
    public synchronized Figure getFigure(int index) {
        return this.figureList.get(index);
    }

    @Override
    public synchronized Figure getFigure(Point2D p, AffineTransform m2v) {
        Figure selectedShape = null;
        for (Figure figure : this.getFigures()) {
            if (!figure.isCloseTo(p, m2v)) continue;
            selectedShape = figure;
        }
        return selectedShape;
    }

    @Override
    public synchronized Figure[] getFigures(Shape shape) {
        ArrayList<Figure> containedFigures = new ArrayList<Figure>(this.getFigureCount());
        for (Figure figure : this.getFigures()) {
            if (!shape.contains(figure.getBounds())) continue;
            containedFigures.add(figure);
        }
        return containedFigures.toArray(new Figure[containedFigures.size()]);
    }

    @Override
    public synchronized Figure[] getFigures() {
        return this.figureList.toArray(new Figure[this.figureList.size()]);
    }

    @Override
    protected boolean addFigureImpl(Figure figure) {
        return this.addFigureImpl(this.getFigureCount(), figure);
    }

    @Override
    protected synchronized boolean addFigureImpl(int index, Figure figure) {
        this.figureSet.add(figure);
        this.figureList.add(index, figure);
        figure.addChangeListener(this.changeDelegate);
        return true;
    }

    @Override
    protected synchronized boolean removeFigureImpl(Figure figure) {
        boolean b = this.figureSet.remove(figure);
        if (b) {
            this.figureList.remove(figure);
            figure.removeChangeListener(this.changeDelegate);
        }
        return b;
    }

    @Override
    protected synchronized Figure[] removeFiguresImpl() {
        Figure[] allFigures;
        for (Figure figure : allFigures = this.getFigures()) {
            figure.removeChangeListener(this.changeDelegate);
        }
        this.figureSet.clear();
        this.figureList.clear();
        return allFigures;
    }

    @Override
    public synchronized Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = this.computeBounds();
        }
        return this.bounds;
    }

    @Override
    public synchronized void move(double dx, double dy) {
        if (this.getFigureCount() > 0) {
            for (Figure figure : this.getFigures()) {
                figure.move(dx, dy);
            }
            this.fireFigureChanged();
        }
    }

    @Override
    public synchronized void scale(Point2D refPoint, double sx, double sy) {
        if (this.getFigureCount() > 0) {
            for (Figure figure : this.getFigures()) {
                figure.scale(refPoint, sx, sy);
            }
            this.fireFigureChanged();
        }
    }

    @Override
    public synchronized void rotate(Point2D point, double theta) {
        if (this.getFigureCount() > 0) {
            for (Figure figure : this.getFigures()) {
                figure.rotate(point, theta);
            }
            this.fireFigureChanged();
        }
    }

    @Override
    public synchronized void draw(Rendering rendering) {
        for (Figure figure : this.getFigures()) {
            figure.draw(rendering);
        }
    }

    @Override
    public synchronized Object createMemento() {
        if (this.getFigureCount() == 0) {
            return null;
        }
        Figure[] figures = this.getFigures();
        HashMap<Figure, Object> mementoMap = new HashMap<Figure, Object>(figures.length);
        for (Figure figure : figures) {
            mementoMap.put(figure, figure.createMemento());
        }
        return mementoMap;
    }

    @Override
    public synchronized void setMemento(Object memento) {
        if (memento != null) {
            Map mementoMap = (Map)memento;
            for (Map.Entry entry : mementoMap.entrySet()) {
                Figure figure = (Figure)entry.getKey();
                figure.setMemento(entry.getValue());
            }
            this.fireFigureChanged();
        }
    }

    protected synchronized Rectangle2D computeBounds() {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        Figure[] figures = this.getFigures();
        if (figures.length > 0) {
            ((Rectangle2D)bounds).setRect(figures[0].getBounds());
            for (int i = 1; i < figures.length; ++i) {
                Figure figure = figures[i];
                bounds.add(figure.getBounds());
            }
        }
        return bounds;
    }

    private synchronized void nullBounds() {
        this.bounds = null;
    }

    private class ChangeDelegate
    implements FigureChangeListener {
        private ChangeDelegate() {
        }

        @Override
        public void figureChanged(FigureChangeEvent e) {
            DefaultFigureCollection.this.fireFigureChanged(e);
        }
    }

    private class BoundsUpdater
    implements FigureChangeListener {
        private BoundsUpdater() {
        }

        @Override
        public void figureChanged(FigureChangeEvent e) {
            DefaultFigureCollection.this.nullBounds();
        }
    }
}

