/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.AbstractFigure;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Handle;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractHandle
extends AbstractFigure
implements Handle {
    private final Figure figure;
    private final FigureChangeListener listener;
    private final Point2D.Double location;
    private Shape shape;

    protected AbstractHandle(Figure figure, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(normalStyle, selectedStyle);
        this.setSelectable(true);
        this.figure = figure;
        this.listener = new FigureChangeListener(){

            @Override
            public void figureChanged(FigureChangeEvent e) {
                AbstractHandle.this.updateLocation();
            }
        };
        this.figure.addChangeListener(this.listener);
        this.location = new Point2D.Double();
    }

    public double getX() {
        return this.location.x;
    }

    public double getY() {
        return this.location.y;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public Point2D getLocation() {
        return (Point2D)this.location.clone();
    }

    public void setLocation(Point2D location) {
        this.setLocation(location.getX(), location.getY());
    }

    public void setLocation(double x, double y) {
        this.location.setLocation(x, y);
    }

    public abstract void updateLocation();

    public Figure getFigure() {
        return this.figure;
    }

    @Override
    public Figure.Rank getRank() {
        return Figure.Rank.AREA;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(Shape shape) {
        this.shape = shape;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.shape.getBounds2D();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isCloseTo(Point2D point, AffineTransform m2v) {
        Point2D.Double delta = new Point2D.Double(point.getX() - this.location.getX(), point.getY() - this.location.getY());
        m2v.deltaTransform(delta, delta);
        return this.getShape().contains(delta);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.figure.removeChangeListener(this.listener);
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public abstract void move(double var1, double var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void draw(Rendering rendering) {
        Graphics2D g = rendering.getGraphics();
        Viewport vp = rendering.getViewport();
        AffineTransform oldTransform = g.getTransform();
        try {
            AffineTransform m2v = vp.getModelToViewTransform();
            Point2D transfLocation = m2v.transform(this.location, null);
            AffineTransform newTransform = new AffineTransform(oldTransform);
            newTransform.concatenate(AffineTransform.getTranslateInstance(transfLocation.getX(), transfLocation.getY()));
            g.setTransform(newTransform);
            this.drawHandle(g);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    protected void drawHandle(Graphics2D g) {
        FigureStyle handleStyle = this.getEffectiveStyle();
        g.setPaint(handleStyle.getFillPaint());
        g.fill(this.getShape());
        g.setPaint(handleStyle.getStrokePaint());
        g.setStroke(handleStyle.getStroke());
        g.draw(this.getShape());
    }
}

