/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleSyncRunner;
import com.bc.ceres.swing.update.TestHelpers;
import junit.framework.TestCase;

public class ModuleSyncRunnerTest
extends TestCase {
    public void testNullArgs() {
        try {
            ModuleSyncRunner.sync(null, (Module[])new Module[0]);
            ModuleSyncRunnerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ModuleSyncRunner.sync((ModuleItem[])new ModuleItem[0], null);
            ModuleSyncRunnerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEmptyModules() {
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(new ModuleItem[0], new Module[0]);
        this.testLength(moduleItems, 0);
    }

    public void testOneInstalledModule() throws CoreException {
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED)}, new Module[0]);
        this.testLength(moduleItems, 0);
    }

    public void testOneInstalledAndOneAvailableModule_DifferentIdsSameVersions() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED)};
        Module[] repositoryModules = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "1.0", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, repositoryModules);
        this.testLength(moduleItems, 1);
        this.testModule(moduleItems[0], "module-b", "1.0", ModuleState.NULL, repositoryModules[0]);
    }

    public void testOneInstalledAndOneAvailableModule_SameIdsSameVersions() throws CoreException {
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED)}, new Module[]{TestHelpers.newRepositoryModuleMock("module-a", "1.0", ModuleState.NULL)});
        this.testLength(moduleItems, 0);
    }

    public void testOneInstalledAndOneAvailableModule_SameIdsDiffVersions() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED)};
        Module[] availableModuleItems = new Module[]{TestHelpers.newRepositoryModuleMock("module-a", "1.1", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, availableModuleItems);
        this.testLength(moduleItems, 0);
        this.testModule(installedModuleItems[0], "module-a", "1.0", ModuleState.INSTALLED, availableModuleItems[0]);
    }

    private static ModuleItem[] sync(ModuleItem[] installedModuleItems, Module[] repositoryModules) {
        return ModuleSyncRunner.sync((ModuleItem[])installedModuleItems, (Module[])repositoryModules);
    }

    public void testTwoInstalledAndTwoAvailableModules_OneCanBeUpdated() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED), TestHelpers.newModuleItemMock("module-c", "1.0", ModuleState.INSTALLED)};
        Module[] availableModuleItems = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "1.0", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-a", "1.1", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, availableModuleItems);
        this.testLength(moduleItems, 1);
        this.testModule(moduleItems[0], "module-b", "1.0", ModuleState.NULL, availableModuleItems[0]);
        this.testModule(installedModuleItems[0], "module-a", "1.0", ModuleState.INSTALLED, availableModuleItems[1]);
        this.testModule(installedModuleItems[1], "module-c", "1.0", ModuleState.INSTALLED, null);
    }

    public void testTwoInstalledAndTwoAvailableModules_OneHasHigherOtherHasLowerVersion() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED), TestHelpers.newModuleItemMock("module-b", "1.0", ModuleState.INSTALLED)};
        Module[] availableModuleItems = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "0.9", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-a", "1.1", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, availableModuleItems);
        this.testLength(moduleItems, 0);
        this.testModule(installedModuleItems[0], "module-a", "1.0", ModuleState.INSTALLED, availableModuleItems[1]);
        this.testModule(installedModuleItems[1], "module-b", "1.0", ModuleState.INSTALLED, null);
    }

    public void testThatUninstalledModulesAreShownAsAvailable() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED), TestHelpers.newModuleItemMock("module-b", "1.0", ModuleState.UNINSTALLED)};
        Module[] availableModuleItems = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "0.9", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-a", "1.1", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, availableModuleItems);
        this.testLength(moduleItems, 0);
    }

    public void testThatLatestUpdateIsSet() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.INSTALLED), TestHelpers.newModuleItemMock("module-b", "1.0", ModuleState.INSTALLED)};
        Module[] availableModuleItems = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "0.9", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-b", "1.5", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-b", "2.0", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-b", "1.2", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, availableModuleItems);
        this.testLength(moduleItems, 0);
        this.testModule(installedModuleItems[0], "module-a", "1.0", ModuleState.INSTALLED, null);
        this.testModule(installedModuleItems[1], "module-b", "1.0", ModuleState.INSTALLED, availableModuleItems[2]);
    }

    public void testTwoUninstalledAndTwoAvailables_SameIdsSameVersions() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.UNINSTALLED), TestHelpers.newModuleItemMock("module-b", "1.0", ModuleState.UNINSTALLED)};
        Module[] repositoryModules = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "1.0", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-a", "1.0", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, repositoryModules);
        this.testLength(moduleItems, 0);
    }

    public void testTwoUninstalledAndTwoAvailables_SameIdsDiffVersions() throws CoreException {
        ModuleItem[] installedModuleItems = new ModuleItem[]{TestHelpers.newModuleItemMock("module-a", "1.0", ModuleState.UNINSTALLED), TestHelpers.newModuleItemMock("module-b", "1.0", ModuleState.UNINSTALLED)};
        Module[] repositoryModules = new Module[]{TestHelpers.newRepositoryModuleMock("module-b", "1.0", ModuleState.NULL), TestHelpers.newRepositoryModuleMock("module-a", "1.1", ModuleState.NULL)};
        ModuleItem[] moduleItems = ModuleSyncRunnerTest.sync(installedModuleItems, repositoryModules);
        this.testLength(moduleItems, 0);
    }

    private void testLength(ModuleItem[] moduleItems, int expectedLength) {
        ModuleSyncRunnerTest.assertNotNull((Object)moduleItems);
        ModuleSyncRunnerTest.assertEquals((int)expectedLength, (int)moduleItems.length);
    }

    private void testModule(ModuleItem moduleItem, String expectedId, String expectedVersion, ModuleState expectedStatus, Module expectedUpdate) {
        ModuleSyncRunnerTest.assertEquals((String)expectedId, (String)moduleItem.getModule().getSymbolicName());
        ModuleSyncRunnerTest.assertEquals((Object)Version.parseVersion((String)expectedVersion), (Object)moduleItem.getModule().getVersion());
        ModuleSyncRunnerTest.assertEquals((Object)expectedStatus, (Object)moduleItem.getModule().getState());
        ModuleSyncRunnerTest.assertSame((Object)expectedUpdate, (Object)moduleItem.getRepositoryModule());
    }
}

