/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import com.bc.ceres.swing.selection.support.DefaultSelectionContext;
import com.bc.ceres.swing.selection.support.SelectionChangeSupport;
import junit.framework.TestCase;

public class SelectionChangeSupportTest
extends TestCase {
    public void testListenerHousekeeping() {
        SelectionChangeSupport ses = new SelectionChangeSupport(null);
        SelectionChangeListener[] listeners = ses.getSelectionChangeListeners();
        SelectionChangeSupportTest.assertNotNull((Object)listeners);
        SelectionChangeSupportTest.assertEquals((int)0, (int)listeners.length);
        MySelectionChangeListener listener1 = new MySelectionChangeListener();
        ses.addSelectionChangeListener((SelectionChangeListener)listener1);
        listeners = ses.getSelectionChangeListeners();
        SelectionChangeSupportTest.assertNotNull((Object)listeners);
        SelectionChangeSupportTest.assertEquals((int)1, (int)listeners.length);
        SelectionChangeSupportTest.assertSame((Object)listener1, (Object)listeners[0]);
        MySelectionChangeListener listener2 = new MySelectionChangeListener();
        ses.addSelectionChangeListener((SelectionChangeListener)listener2);
        listeners = ses.getSelectionChangeListeners();
        SelectionChangeSupportTest.assertNotNull((Object)listeners);
        SelectionChangeSupportTest.assertEquals((int)2, (int)listeners.length);
        SelectionChangeSupportTest.assertSame((Object)listener1, (Object)listeners[0]);
        SelectionChangeSupportTest.assertSame((Object)listener2, (Object)listeners[1]);
    }

    public void testListenerDispatching() {
        String eventSource1 = "A";
        String eventSource2 = "B";
        this.testExpliciteEvent(new SelectionChangeSupport(), eventSource1);
        this.testExpliciteEvent(new SelectionChangeSupport(null), eventSource1);
        this.testExpliciteEvent(new SelectionChangeSupport((Object)"A"), eventSource1);
        this.testExpliciteEvent(new SelectionChangeSupport(), eventSource2);
        this.testExpliciteEvent(new SelectionChangeSupport(null), eventSource2);
        this.testExpliciteEvent(new SelectionChangeSupport((Object)"A"), eventSource2);
        SelectionChangeSupport selectionChangeSupport = new SelectionChangeSupport();
        this.testImpliciteEvent(selectionChangeSupport, selectionChangeSupport);
        selectionChangeSupport = new SelectionChangeSupport(null);
        this.testImpliciteEvent(selectionChangeSupport, selectionChangeSupport);
        selectionChangeSupport = new SelectionChangeSupport((Object)eventSource1);
        this.testImpliciteEvent(selectionChangeSupport, eventSource1);
        selectionChangeSupport = new SelectionChangeSupport((Object)eventSource2);
        this.testImpliciteEvent(selectionChangeSupport, eventSource2);
    }

    private Selection testExpliciteEvent(SelectionChangeSupport ses, Object expectedSource) {
        DefaultSelectionContext selectionContext = new DefaultSelectionContext();
        DefaultSelection selection = new DefaultSelection(new Object[]{"A"});
        MySelectionChangeListener listener1 = new MySelectionChangeListener();
        MySelectionChangeListener listener2 = new MySelectionChangeListener();
        ses.addSelectionChangeListener((SelectionChangeListener)listener1);
        ses.addSelectionChangeListener((SelectionChangeListener)listener2);
        ses.fireSelectionChange(new SelectionChangeEvent(expectedSource, (SelectionContext)selectionContext, (Selection)selection));
        SelectionChangeSupportTest.assertNotNull((Object)listener1.event);
        SelectionChangeSupportTest.assertNotNull((Object)listener2.event);
        SelectionChangeSupportTest.assertSame((Object)expectedSource, (Object)listener1.event.getSource());
        SelectionChangeSupportTest.assertSame((Object)expectedSource, (Object)listener2.event.getSource());
        SelectionChangeSupportTest.assertSame((Object)selectionContext, (Object)listener1.event.getSelectionContext());
        SelectionChangeSupportTest.assertSame((Object)selectionContext, (Object)listener2.event.getSelectionContext());
        SelectionChangeSupportTest.assertSame((Object)selection, (Object)listener1.event.getSelection());
        SelectionChangeSupportTest.assertSame((Object)selection, (Object)listener2.event.getSelection());
        return selection;
    }

    private Selection testImpliciteEvent(SelectionChangeSupport ses, Object expectedSource) {
        DefaultSelectionContext selectionContext = new DefaultSelectionContext();
        DefaultSelection selection = new DefaultSelection(new Object[]{"A"});
        MySelectionChangeListener listener1 = new MySelectionChangeListener();
        MySelectionChangeListener listener2 = new MySelectionChangeListener();
        ses.addSelectionChangeListener((SelectionChangeListener)listener1);
        ses.addSelectionChangeListener((SelectionChangeListener)listener2);
        ses.fireSelectionChange((SelectionContext)selectionContext, (Selection)selection);
        SelectionChangeSupportTest.assertNotNull((Object)listener1.event);
        SelectionChangeSupportTest.assertNotNull((Object)listener2.event);
        SelectionChangeSupportTest.assertSame((Object)expectedSource, (Object)listener1.event.getSource());
        SelectionChangeSupportTest.assertSame((Object)expectedSource, (Object)listener2.event.getSource());
        SelectionChangeSupportTest.assertSame((Object)selectionContext, (Object)listener1.event.getSelectionContext());
        SelectionChangeSupportTest.assertSame((Object)selectionContext, (Object)listener2.event.getSelectionContext());
        SelectionChangeSupportTest.assertSame((Object)selection, (Object)listener1.event.getSelection());
        SelectionChangeSupportTest.assertSame((Object)selection, (Object)listener2.event.getSelection());
        return selection;
    }

    private static class MySelectionChangeListener
    implements SelectionChangeListener {
        SelectionChangeEvent event;

        private MySelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            this.event = event;
        }

        public void selectionContextChanged(SelectionChangeEvent event) {
            this.event = event;
        }
    }
}

