/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.junit.Ignore;

@Ignore
public class DefaultShapeFigureTest {
    public static void main(String[] args) {
        DefaultShapeFigureTest.doit(0, false, false, false);
        DefaultShapeFigureTest.doit(0, false, false, true);
        DefaultShapeFigureTest.doit(0, false, true, false);
        DefaultShapeFigureTest.doit(0, false, true, true);
        DefaultShapeFigureTest.doit(0, true, false, false);
        DefaultShapeFigureTest.doit(0, true, false, true);
        DefaultShapeFigureTest.doit(0, true, true, false);
        DefaultShapeFigureTest.doit(0, true, true, true);
        DefaultShapeFigureTest.doit(1, false, false, false);
        DefaultShapeFigureTest.doit(1, false, false, true);
        DefaultShapeFigureTest.doit(1, false, true, false);
        DefaultShapeFigureTest.doit(1, false, true, true);
        DefaultShapeFigureTest.doit(1, true, false, false);
        DefaultShapeFigureTest.doit(1, true, false, true);
        DefaultShapeFigureTest.doit(1, true, true, false);
        DefaultShapeFigureTest.doit(1, true, true, true);
    }

    private static void doit(int winding, boolean clockwise1, boolean clockwise2, boolean clockwise3) {
        Path2D.Double path = new Path2D.Double(winding);
        path.append(DefaultShapeFigureTest.rectPath(clockwise1, 0, 0, 100, 100), false);
        path.append(DefaultShapeFigureTest.rectPath(clockwise2, 12, 12, 25, 25), false);
        path.append(DefaultShapeFigureTest.rectPath(clockwise3, 65, 65, 25, 25), false);
        StringBuilder sb = new StringBuilder();
        if (winding == 0) {
            sb.append("WEO");
        } else {
            sb.append("WNZ");
        }
        sb.append(" - ");
        sb.append(String.valueOf(clockwise1));
        sb.append(", ");
        sb.append(String.valueOf(clockwise2));
        sb.append(", ");
        sb.append(String.valueOf(clockwise3));
        DefaultShapeFigureTest.show(path, sb.toString());
    }

    private static Path2D rectPath(boolean clockwise, int x, int y, int w, int h) {
        Path2D.Double linePath = new Path2D.Double();
        linePath.moveTo(x, y);
        if (clockwise) {
            linePath.lineTo(x, y + h);
            linePath.lineTo(x + w, y + h);
            linePath.lineTo(x + w, y);
        } else {
            linePath.lineTo(x + w, y);
            linePath.lineTo(x + w, y + h);
            linePath.lineTo(x, y + h);
        }
        linePath.lineTo(x, y);
        linePath.closePath();
        return linePath;
    }

    private static void show(final Shape shape, String title) {
        JFrame frame = new JFrame(title);
        JPanel canvas = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                int i;
                super.paintComponent(g);
                g.setColor(Color.GRAY);
                for (i = 0; i < this.getWidth(); i += 10) {
                    g.drawLine(i, 0, i, this.getHeight());
                }
                for (i = 0; i < this.getHeight(); i += 10) {
                    g.drawLine(0, i, this.getWidth(), i);
                }
                Graphics2D graphics2D = (Graphics2D)g;
                graphics2D.translate(10, 10);
                graphics2D.setPaint(new Color(255, 255, 255, 150));
                graphics2D.fill(shape);
                graphics2D.setPaint(Color.BLUE);
                graphics2D.draw(shape);
            }
        };
        canvas.setBorder(new EmptyBorder(9, 9, 9, 9));
        canvas.setPreferredSize(new Dimension(shape.getBounds().width + 20, shape.getBounds().height + 20));
        frame.getContentPane().add(canvas);
        frame.pack();
        frame.setVisible(true);
        System.out.println("Shape " + title);
        PathIterator pathIterator = shape.getPathIterator(null);
        if (pathIterator.getWindingRule() == 0) {
            System.out.println("WIND_EVEN_ODD");
        } else if (pathIterator.getWindingRule() == 1) {
            System.out.println("WIND_NON_ZERO");
        } else {
            System.out.println("WIND_?");
        }
        while (!pathIterator.isDone()) {
            double[] seg = new double[6];
            int i = pathIterator.currentSegment(seg);
            if (i == 1) {
                System.out.printf("SEG_LINETO: %s, %s%n", seg[0], seg[1]);
            } else if (i == 0) {
                System.out.printf("SEG_MOVETO: %s, %s%n", seg[0], seg[1]);
            } else if (i == 2) {
                System.out.printf("SEG_QUADTO: %s, %s, %s, %s%n", seg[0], seg[1], seg[2], seg[3]);
            } else if (i == 3) {
                System.out.printf("SEG_CUBICTO: %s, %s, %s, %s, %s, %s%n", seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
            } else if (i == 4) {
                System.out.println("SEG_CLOSE");
            } else {
                System.out.println("SEG_?");
            }
            pathIterator.next();
        }
    }
}

