/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.swing.figure.AbstractFigure;
import com.bc.ceres.swing.figure.AbstractFigureImpl;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.TestFigure;
import java.awt.geom.AffineTransform;
import junit.framework.TestCase;

public class AbstractFigureTest
extends TestCase {
    public void testDefaultProperties() {
        AbstractFigureImpl f = new AbstractFigureImpl();
        AbstractFigureTest.assertNotNull((Object)f.getChangeListeners());
        AbstractFigureTest.assertEquals((boolean)false, (boolean)f.isSelectable());
        AbstractFigureTest.assertEquals((int)0, (int)f.getChangeListeners().length);
        AbstractFigureTest.assertEquals(null, (Object)f.getFigure(null, new AffineTransform()));
        AbstractFigureTest.assertEquals((int)0, (int)f.getFigureCount());
        AbstractFigureTest.assertEquals((int)0, (int)f.getMaxSelectionStage());
        AbstractFigureTest.assertNull((Object)f.getFigure(null, new AffineTransform()));
        AbstractFigureTest.assertNotNull((Object)f.getFigures(null));
        AbstractFigureTest.assertEquals((int)0, (int)f.getFigures(null).length);
        AbstractFigureTest.assertNotNull((Object)f.getFigures());
        AbstractFigureTest.assertEquals((int)0, (int)f.getFigures().length);
        AbstractFigureTest.assertEquals((int)0, (int)f.getMaxSelectionStage());
        AbstractFigureTest.assertNotNull((Object)f.createHandles(1));
        AbstractFigureTest.assertEquals((int)0, (int)f.createHandles(1).length);
    }

    public void testThatCloneDoesNotCopyListeners() {
        AbstractFigureImpl f = new AbstractFigureImpl();
        f.addChangeListener(new FigureChangeListener(){

            public void figureChanged(FigureChangeEvent event) {
            }
        });
        AbstractFigure cf = (AbstractFigure)f.clone();
        AbstractFigureTest.assertNotNull((Object)cf.getChangeListeners());
        AbstractFigureTest.assertEquals((int)0, (int)cf.getChangeListeners().length);
    }

    public void testListeners() {
        AbstractFigureImpl f = new AbstractFigureImpl();
        final Figure[] figureBuf = new Figure[1];
        f.addChangeListener(new FigureChangeListener(){

            public void figureChanged(FigureChangeEvent event) {
                figureBuf[0] = event.getSourceFigure();
            }
        });
        AbstractFigureTest.assertEquals(null, (Object)figureBuf[0]);
        f.postChangeEvent();
        AbstractFigureTest.assertEquals((Object)((Object)f), (Object)figureBuf[0]);
    }

    public void testDisposeRemovesListeners() {
        AbstractFigureImpl f = new AbstractFigureImpl();
        f.addChangeListener(new FigureChangeListener(){

            public void figureChanged(FigureChangeEvent event) {
            }
        });
        FigureChangeListener[] listeners = f.getChangeListeners();
        AbstractFigureTest.assertNotNull((Object)listeners);
        AbstractFigureTest.assertTrue((listeners.length >= 1 ? 1 : 0) != 0);
        f.dispose();
        listeners = f.getChangeListeners();
        AbstractFigureTest.assertNotNull((Object)listeners);
        AbstractFigureTest.assertEquals((int)0, (int)listeners.length);
    }

    public void testGeometricOperationsAreNotSupported() {
        AbstractFigureImpl f = new AbstractFigureImpl();
        try {
            f.move(0.0, 0.0);
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.rotate(null, 0.0);
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.scale(null, 0.0, 0.0);
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testThatChildrenAreNotSupported() {
        AbstractFigureImpl f = new AbstractFigureImpl();
        try {
            f.addFigure((Figure)new TestFigure());
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.addFigure(0, (Figure)new TestFigure());
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.addFigures(new Figure[]{new TestFigure(), new TestFigure()});
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.getFigure(0);
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.removeFigure((Figure)new TestFigure());
            AbstractFigureTest.fail((String)"IllegalStateException expected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

