/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.RangeEditor;
import javax.swing.JComponent;
import javax.swing.JSlider;
import junit.framework.TestCase;

public class RangeEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        RangeEditor rangeEditor = new RangeEditor();
        PropertyDescriptor doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        ValueRange valueRange = ValueRange.parseValueRange((String)"[2.0,4.6]");
        doubleDescriptor.setValueRange(valueRange);
        RangeEditorTest.assertFalse((boolean)rangeEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.class);
        RangeEditorTest.assertFalse((boolean)rangeEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        valueRange = ValueRange.parseValueRange((String)"[2.0,*)");
        doubleDescriptor.setValueRange(valueRange);
        RangeEditorTest.assertFalse((boolean)rangeEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        valueRange = ValueRange.parseValueRange((String)"[*,4.6)");
        doubleDescriptor.setValueRange(valueRange);
        RangeEditorTest.assertFalse((boolean)rangeEditor.isValidFor(doubleDescriptor));
        PropertyDescriptor booleanDescriptor = new PropertyDescriptor("test", Boolean.TYPE);
        RangeEditorTest.assertFalse((boolean)rangeEditor.isValidFor(booleanDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        RangeEditor rangeEditor = new RangeEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("value");
        ValueRange valueRange = ValueRange.parseValueRange((String)"[2.0,4.6]");
        propertyDescriptor.setValueRange(valueRange);
        RangeEditorTest.assertSame(Double.TYPE, (Object)propertyDescriptor.getType());
        JComponent editorComponent = rangeEditor.createEditorComponent(propertyDescriptor, bindingContext);
        RangeEditorTest.assertNotNull((Object)editorComponent);
        RangeEditorTest.assertSame(JSlider.class, editorComponent.getClass());
        JComponent[] components = bindingContext.getBinding("value").getComponents();
        RangeEditorTest.assertEquals((int)1, (int)components.length);
        RangeEditorTest.assertSame(JSlider.class, components[0].getClass());
    }

    private static class V {
        double value;

        private V() {
        }
    }
}

