/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.standalone;

import com.bc.ceres.metadata.DefaultSimpleFileSystem;
import com.bc.ceres.metadata.MetadataResourceEngine;
import com.bc.ceres.metadata.XPathHandler;
import com.bc.ceres.standalone.CliHandler;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.velocity.VelocityContext;

public class MetadataEngineMain {
    public static final String KEY_METADATA = "metadata";
    public static final String KEY_SOURCES = "sourcePaths";
    public static final String KEY_XPATH = "xpath";
    public static final String KEY_TARGET = "targetPath";
    public static final String KEY_SYSTEM = "system";
    public static final String KEY_ARGS = "commandLineArgs";
    public static final String KEY_DATE_FORMAT = "dateFormat";
    public static final String KEY_DATE = "date";
    private MetadataResourceEngine metadataResourceEngine;
    private CliHandler cliHandler;

    public MetadataEngineMain(MetadataResourceEngine metadataResourceEngine) {
        this.metadataResourceEngine = metadataResourceEngine;
    }

    public static void main(String[] commandLineArgs) {
        MetadataEngineMain metadataEngineMain = null;
        try {
            metadataEngineMain = new MetadataEngineMain(new MetadataResourceEngine(new DefaultSimpleFileSystem()));
            metadataEngineMain.setCliHandler(new CliHandler(commandLineArgs));
            if (commandLineArgs.length < 2) {
                metadataEngineMain.cliHandler.printUsage();
                System.err.print("Error in MetadataEngineMain: The two options -v and -t are mandatory. ");
                System.exit(1);
            } else {
                metadataEngineMain.processMetadata();
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error in MetadataEngineMain:" + e.getMessage());
            metadataEngineMain.cliHandler.printUsage();
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println(e.getClass() + "Error in MetadataEngineMain:" + e.getMessage());
            System.exit(3);
        }
    }

    void processMetadata() throws Exception {
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put(KEY_DATE_FORMAT, (Object)new SimpleDateFormat("yyyy-MM-dd"));
        velocityContext.put(KEY_DATE, (Object)new Date());
        HashMap<String, String> metadataPaths = this.cliHandler.fetchGlobalMetadataFiles();
        for (String string : metadataPaths.keySet()) {
            this.metadataResourceEngine.readResource(string, metadataPaths.get(string));
        }
        HashMap<String, String> sourcePaths = this.cliHandler.fetchSourceItemFiles();
        for (String key : sourcePaths.keySet()) {
            this.metadataResourceEngine.readRelatedResource(key, (String)sourcePaths.get(key));
        }
        velocityContext.put(KEY_XPATH, (Object)new XPathHandler());
        velocityContext.put(KEY_SOURCES, sourcePaths);
        velocityContext.put(KEY_SYSTEM, (Object)System.getProperties());
        velocityContext.put(KEY_ARGS, Arrays.asList(this.cliHandler.fetchArguments()));
        HashMap<String, String> hashMap = this.cliHandler.fetchTemplateFiles();
        String outputItemPath = this.cliHandler.fetchTargetItemFile();
        velocityContext.put(KEY_TARGET, (Object)outputItemPath);
        for (String templateKey : hashMap.keySet()) {
            this.metadataResourceEngine.writeRelatedResource((String)hashMap.get(templateKey), outputItemPath);
        }
    }

    void setCliHandler(CliHandler cliHandler) {
        this.cliHandler = cliHandler;
    }
}

