/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.js;

import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterListDescriptor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class JsJaiFunction
extends ScriptableObject
implements Function {
    private final OperationDescriptor operationDescriptor;
    private final String name;

    public JsJaiFunction(OperationDescriptor operationDescriptor) {
        this.operationDescriptor = operationDescriptor;
        this.name = operationDescriptor.getName().toLowerCase();
    }

    public JsJaiFunction(Scriptable scope, Scriptable prototype, OperationDescriptor operationDescriptor) {
        super(scope, prototype);
        this.operationDescriptor = operationDescriptor;
        this.name = operationDescriptor.getName().toLowerCase();
    }

    public OperationDescriptor getOperationDescriptor() {
        return this.operationDescriptor;
    }

    public String getClassName() {
        return this.name;
    }

    public Scriptable construct(Context context, Scriptable scope, Object[] args) {
        return new JsJaiFunction(this.operationDescriptor);
    }

    public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) {
        ParameterBlockJAI pb = new ParameterBlockJAI(this.operationDescriptor);
        int numSources = this.operationDescriptor.getNumSources();
        ParameterListDescriptor pld = this.operationDescriptor.getParameterListDescriptor("rendered");
        int numParams = pld.getNumParameters();
        String[] paramNames = pld.getParamNames();
        Class[] paramTypes = pld.getParamClasses();
        try {
            int i;
            for (i = 0; i < numSources; ++i) {
                if (i >= args.length) {
                    String[] sourceNames = this.operationDescriptor.getSourceNames();
                    throw new IllegalArgumentException("Missing argument #" + (i + 1) + " (" + sourceNames[i] + ")");
                }
                pb.addSource(args[i]);
            }
            for (i = 0; i < numParams; ++i) {
                Object paramValue;
                String paramName = paramNames[i];
                Class paramType = paramTypes[i];
                int j = numSources + i;
                if (j < args.length) {
                    paramValue = this.convertJsToJaiValue(args[j], paramType);
                } else {
                    paramValue = pld.getParamDefaultValue(paramName);
                    if (paramValue == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
                        throw new IllegalArgumentException("Missing argument #" + (j + 1) + " (" + paramName + ")");
                    }
                }
                pb.setParameter(paramName, paramValue);
            }
            return JAI.create((String)this.getClassName(), (ParameterBlock)pb);
        }
        catch (IllegalArgumentException t) {
            throw new WrappedException((Throwable)t);
        }
    }

    private Object convertJsToJaiValue(Object arg, Class paramType) {
        if (Number.class.isAssignableFrom(paramType)) {
            if (paramType == Byte.class) {
                return (byte)Context.toNumber((Object)arg);
            }
            if (paramType == Short.class) {
                return (short)Context.toNumber((Object)arg);
            }
            if (paramType == Integer.class) {
                return (int)Context.toNumber((Object)arg);
            }
            if (paramType == Long.class) {
                return (long)Context.toNumber((Object)arg);
            }
            if (paramType == Float.class) {
                return Float.valueOf((float)Context.toNumber((Object)arg));
            }
            return Context.toNumber((Object)arg);
        }
        if (Boolean.class.isAssignableFrom(paramType)) {
            return Context.toBoolean((Object)arg);
        }
        if (String.class.isAssignableFrom(paramType)) {
            return Context.toString((Object)arg);
        }
        return Context.jsToJava((Object)arg, (Class)paramType);
    }

    public Object getDefaultValue(Class aClass) {
        if (aClass == String.class) {
            return "[" + this.getClassName() + "]";
        }
        if (aClass == Boolean.class) {
            return false;
        }
        if (aClass == Number.class) {
            return 0;
        }
        if (aClass == Scriptable.class) {
            return this;
        }
        return null;
    }
}

