/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;

public class DefaultMultiLevelModel
implements MultiLevelModel {
    public static final int DEFAULT_MAX_LEVEL_PIXEL_COUNT = 65536;
    private final int levelCount;
    private final AffineTransform[] imageToModelTransforms;
    private final AffineTransform[] modelToImageTransforms;
    private Rectangle2D modelBounds;

    public DefaultMultiLevelModel(AffineTransform imageToModelTransform, int width, int height) {
        this(DefaultMultiLevelModel.getLevelCount(width, height), imageToModelTransform, DefaultMultiLevelModel.getModelBounds(imageToModelTransform, width, height));
    }

    public DefaultMultiLevelModel(int levelCount, AffineTransform imageToModelTransform, int width, int height) {
        this(levelCount, imageToModelTransform, DefaultMultiLevelModel.getModelBounds(imageToModelTransform, width, height));
    }

    public DefaultMultiLevelModel(int levelCount, AffineTransform imageToModelTransform, Rectangle2D modelBounds) {
        AffineTransform modelToImageTransform;
        this.levelCount = levelCount;
        try {
            modelToImageTransform = imageToModelTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("imageToModelTransform", e);
        }
        this.imageToModelTransforms = new AffineTransform[levelCount];
        this.modelToImageTransforms = new AffineTransform[levelCount];
        this.imageToModelTransforms[0] = new AffineTransform(imageToModelTransform);
        this.modelToImageTransforms[0] = new AffineTransform(modelToImageTransform);
        this.setModelBounds(modelBounds);
    }

    @Override
    public int getLevelCount() {
        return this.levelCount;
    }

    @Override
    public int getLevel(double scale) {
        int level = (int)Math.floor(DefaultMultiLevelModel.log2(scale));
        if (level < 0) {
            level = 0;
        } else if (level >= this.levelCount) {
            level = this.levelCount - 1;
        }
        return level;
    }

    @Override
    public double getScale(int level) {
        this.checkLevel(level);
        return DefaultMultiLevelModel.pow2(level);
    }

    @Override
    public final AffineTransform getImageToModelTransform(int level) {
        this.checkLevel(level);
        AffineTransform transform = this.imageToModelTransforms[level];
        if (transform == null) {
            transform = new AffineTransform(this.imageToModelTransforms[0]);
            double s = this.getScale(level);
            transform.scale(s, s);
            this.imageToModelTransforms[level] = transform;
        }
        return new AffineTransform(transform);
    }

    @Override
    public final AffineTransform getModelToImageTransform(int level) {
        this.checkLevel(level);
        AffineTransform transform = this.modelToImageTransforms[level];
        if (transform == null) {
            try {
                this.modelToImageTransforms[level] = transform = this.getImageToModelTransform(level).createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalStateException(e);
            }
        }
        return new AffineTransform(transform);
    }

    protected static double pow2(double v) {
        return Math.pow(2.0, v);
    }

    protected static double log2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    protected void checkLevel(int level) {
        if (level < 0 || level >= this.getLevelCount()) {
            throw new IllegalArgumentException("level");
        }
    }

    @Override
    public Rectangle2D getModelBounds() {
        if (this.modelBounds != null) {
            return (Rectangle2D)this.modelBounds.clone();
        }
        return null;
    }

    public void setModelBounds(Rectangle2D modelBounds) {
        this.modelBounds = modelBounds != null ? (Rectangle2D)modelBounds.clone() : null;
    }

    public static Rectangle2D getModelBounds(AffineTransform i2mTransform, RenderedImage levelZeroImage) {
        return i2mTransform.createTransformedShape(new Rectangle(levelZeroImage.getMinX(), levelZeroImage.getMinY(), levelZeroImage.getWidth(), levelZeroImage.getHeight())).getBounds2D();
    }

    public static Rectangle2D getModelBounds(AffineTransform i2mTransform, int width, int height) {
        return i2mTransform.createTransformedShape(new Rectangle(0, 0, width, height)).getBounds2D();
    }

    public static int getLevelCount(int width, int height) {
        int levelCount = 1;
        double scale = 1.0;
        while (scale * (double)width * (scale * (double)height) >= 65536.0) {
            ++levelCount;
            scale *= 0.5;
        }
        return levelCount;
    }
}

