/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.swing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class NavControl
extends JComponent {
    private static final Dimension PREFERRED_SIZE = new Dimension(100, 120);
    private static final int TIMER_DELAY = 50;
    private final NavControlModel model;
    private double pannerHandleOffsetX;
    private double pannerHandleOffsetY;
    private double scaleHandleOffsetX;
    private double scaleHandleOffsetY;
    private Ellipse2D outerRotationCircle;
    private Ellipse2D innerRotationCircle;
    private Ellipse2D outerMoveCircle;
    private Shape pannerHandle;
    private Shape[] moveArrowShapes;
    private Area[] rotationUnitShapes;
    private RectangularShape scaleHandle;
    private RectangularShape scaleBar;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ROT = 1;
    private static final int ACTION_SCALE = 2;
    private static final int ACTION_PAN = 3;
    private static final int ACTION_MOVE_N = 4;
    private static final int ACTION_MOVE_S = 5;
    private static final int ACTION_MOVE_W = 6;
    private static final int ACTION_MOVE_E = 7;
    private static final int[] ACTION_MOVE_DIRS = new int[]{4, 5, 6, 7};
    private static final double[] X_DIRS = new double[]{0.0, -1.0, 0.0, 1.0};
    private static final double[] Y_DIRS = new double[]{1.0, 0.0, -1.0, 0.0};

    public NavControl(NavControlModel model) {
        this.model = model;
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setBounds(0, 0, NavControl.PREFERRED_SIZE.width, NavControl.PREFERRED_SIZE.height);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return PREFERRED_SIZE;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateGeom();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        AffineTransform oldTransform = graphics2D.getTransform();
        graphics2D.setStroke(new BasicStroke(0.6f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.rotate(-1.5707963267948966 - Math.toRadians(this.model.getCurrentAngle()), this.outerRotationCircle.getCenterX(), this.outerRotationCircle.getCenterY());
        for (int i = 0; i < this.rotationUnitShapes.length; ++i) {
            graphics2D.setColor(i == 0 ? Color.ORANGE : Color.WHITE);
            graphics2D.fill(this.rotationUnitShapes[i]);
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(this.rotationUnitShapes[i]);
        }
        graphics2D.setTransform(oldTransform);
        for (Shape arrow : this.moveArrowShapes) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(arrow);
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(arrow);
        }
        graphics2D.translate(this.pannerHandleOffsetX, this.pannerHandleOffsetY);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.pannerHandle);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.pannerHandle);
        graphics2D.setTransform(oldTransform);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.scaleBar);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.scaleBar);
        graphics2D.translate(this.scaleHandleOffsetX, this.scaleHandleOffsetY);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.scaleHandle);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.scaleHandle);
        graphics2D.setTransform(oldTransform);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getAction(x, y) != 0;
    }

    private void updateGeom() {
        double outerRotationDiameter;
        double h;
        double scaleHandleW = Math.max(4.0, 0.025 * (double)this.getWidth());
        double scaleHandleH = 4.0 * scaleHandleW;
        double gap = Math.max(4.0, 0.05 * (double)this.getHeight());
        Insets insets = this.getInsets();
        double x = insets.left;
        double y = insets.top;
        double w = this.getWidth() - (insets.left + insets.right) - 2;
        if (w > (h = (double)this.getHeight() - ((double)(insets.top + insets.bottom) + gap + scaleHandleH) - 2.0)) {
            x += (w - h) / 2.0;
            outerRotationDiameter = h;
        } else {
            y += (h - w) / 2.0;
            outerRotationDiameter = w;
        }
        double innerRotationDiameter = 0.8 * outerRotationDiameter;
        double outerMoveDiameter = 0.4 * outerRotationDiameter;
        this.outerRotationCircle = new Ellipse2D.Double(x, y, outerRotationDiameter, outerRotationDiameter);
        this.innerRotationCircle = new Ellipse2D.Double(this.outerRotationCircle.getCenterX() - 0.5 * innerRotationDiameter, this.outerRotationCircle.getCenterY() - 0.5 * innerRotationDiameter, innerRotationDiameter, innerRotationDiameter);
        this.outerMoveCircle = new Ellipse2D.Double(this.innerRotationCircle.getCenterX() - 0.5 * outerMoveDiameter, this.innerRotationCircle.getCenterY() - 0.5 * outerMoveDiameter, outerMoveDiameter, outerMoveDiameter);
        this.rotationUnitShapes = this.createRotationUnitShapes();
        this.moveArrowShapes = this.createMoveArrows();
        this.pannerHandle = this.createPanner();
        double scaleBarW = outerRotationDiameter;
        double scaleBarH = scaleHandleW;
        double scaleBarX = x;
        double scaleHandleY = y + outerRotationDiameter + gap;
        this.scaleBar = new Rectangle2D.Double(scaleBarX, scaleHandleY + 0.5 * (scaleHandleH - scaleBarH), scaleBarW, scaleBarH);
        this.scaleHandle = new Rectangle2D.Double(scaleBarX + 0.5 * (scaleBarW - scaleHandleW), scaleHandleY, scaleHandleW, scaleHandleH);
    }

    private Shape createPanner() {
        double innerRadius = 0.5 * this.innerRotationCircle.getWidth();
        double s = 0.25 * innerRadius;
        Rectangle2D.Double r1 = new Rectangle2D.Double(-0.5 * s, -0.5 * s, s, s);
        Shape r2 = AffineTransform.getRotateInstance(0.7853981633974483).createTransformedShape(r1);
        Area area = new Area(r1);
        area.add(new Area(r2));
        return AffineTransform.getTranslateInstance(this.innerRotationCircle.getCenterX(), this.innerRotationCircle.getCenterY()).createTransformedShape(area);
    }

    private Shape[] createMoveArrows() {
        double innerRadius = 0.5 * this.innerRotationCircle.getWidth();
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(2.0f, 1.0f);
        path.lineTo(1.0f, 1.0f);
        path.lineTo(1.0f, 2.0f);
        path.lineTo(-1.0f, 2.0f);
        path.lineTo(-1.0f, 1.0f);
        path.lineTo(-2.0f, 1.0f);
        path.closePath();
        Shape[] arrows = new Shape[4];
        for (int i = 0; i < 4; ++i) {
            AffineTransform at = new AffineTransform();
            at.rotate((double)i * 0.5 * Math.PI, this.innerRotationCircle.getCenterX(), this.innerRotationCircle.getCenterY());
            at.translate(this.innerRotationCircle.getCenterX(), this.innerRotationCircle.getCenterY() - 0.95 * innerRadius);
            at.scale(0.2 * innerRadius, 0.3 * innerRadius);
            Area area = new Area(at.createTransformedShape(path));
            area.subtract(new Area(this.outerMoveCircle));
            arrows[i] = area;
        }
        return arrows;
    }

    private Area[] createRotationUnitShapes() {
        Area[] areas = new Area[36];
        Area rhs = new Area(this.innerRotationCircle);
        for (int i = 0; i < 36; ++i) {
            Arc2D.Double arc = new Arc2D.Double(this.outerRotationCircle.getX(), this.outerRotationCircle.getY(), this.outerRotationCircle.getWidth(), this.outerRotationCircle.getHeight(), (double)(i * 10) - 3.5, 7.0, 2);
            Area area = new Area(arc);
            area.subtract(rhs);
            areas[i] = area;
        }
        return areas;
    }

    private double getAngle(Point point) {
        double a = Math.atan2(-((double)point.y - this.innerRotationCircle.getCenterY()), (double)point.x - this.innerRotationCircle.getCenterX());
        return NavControl.normaliseAngle(a - 1.5707963267948966);
    }

    private static double normaliseAngle(double a) {
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        if ((a %= Math.PI * 2) > Math.PI) {
            a += Math.PI * -2;
        }
        return a;
    }

    int getAction(int x, int y) {
        if (super.contains(x, y)) {
            if (this.outerRotationCircle.contains(x, y) && !this.innerRotationCircle.contains(x, y)) {
                return 1;
            }
            if (this.pannerHandle.contains(x, y)) {
                return 3;
            }
            if (this.scaleHandle.contains(x, y) || this.scaleBar.contains(x, y)) {
                return 2;
            }
            for (int i = 0; i < this.moveArrowShapes.length; ++i) {
                Shape moveArrowShape = this.moveArrowShapes[i];
                if (!moveArrowShape.contains(x, y)) continue;
                return ACTION_MOVE_DIRS[i];
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("NavControl");
        JPanel panel = new JPanel(new BorderLayout(3, 3));
        panel.setBackground(Color.GRAY);
        final JLabel label = new JLabel("Angle: ");
        NavControl navControl = new NavControl(new NavControlModel(){
            double angle;

            @Override
            public double getCurrentAngle() {
                return this.angle;
            }

            @Override
            public void handleRotate(double rotationAngle) {
                this.angle = rotationAngle;
                label.setText("Angle: " + rotationAngle);
                System.out.println("NavControl: rotationAngle = " + rotationAngle);
            }

            @Override
            public void handleMove(double moveDirX, double moveDirY) {
                System.out.println("NavControl: moveDirX = " + moveDirX + ", moveDirY = " + moveDirY);
            }

            @Override
            public void handleScale(double scaleDir) {
                System.out.println("NavControl: scaleDir = " + scaleDir);
            }
        });
        navControl.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)label, "South");
        panel.add((Component)navControl, "Center");
        frame.add(panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private class MouseHandler
    extends MouseInputAdapter
    implements ActionListener {
        private Point point0;
        private double rotationAngle0;
        private double moveDirX;
        private double moveDirY;
        private double moveAcc;
        private double scaleDir;
        private double scaleAcc;
        private Cursor cursor0;
        private final Timer actionTrigger = new Timer(50, this);
        private int action = 0;

        private MouseHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.action == 3 || this.action == 4 || this.action == 5 || this.action == 6 || this.action == 7) {
                this.fireAcceleratedMove();
            } else if (this.action == 2) {
                this.fireAcceleratedScale();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.cursor0 = NavControl.this.getCursor();
            this.point0 = e.getPoint();
            this.moveAcc = 1.0;
            this.scaleAcc = 1.0;
            this.action = NavControl.this.getAction(e.getX(), e.getY());
            if (this.action == 1) {
                this.rotationAngle0 = NavControl.this.model.getCurrentAngle();
            } else if (this.action == 2) {
                this.doScale(e);
            } else if (this.action == 4) {
                this.startMove(0);
            } else if (this.action == 5) {
                this.startMove(1);
            } else if (this.action == 6) {
                this.startMove(2);
            } else if (this.action == 7) {
                this.startMove(3);
            }
            if (this.action != 0) {
                NavControl.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.action == 1) {
                this.doRotate(e);
            } else if (this.action == 3) {
                this.doPan(e);
            } else if (this.action == 2) {
                this.doScale(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.stopAction();
        }

        private void doScale(MouseEvent e) {
            double a;
            Point point = e.getPoint();
            double dx = (double)point.x - NavControl.this.scaleBar.getCenterX();
            if (dx < -(a = 0.5 * (NavControl.this.scaleBar.getWidth() - NavControl.this.scaleHandle.getWidth()))) {
                dx = -a;
            }
            if (dx > a) {
                dx = a;
            }
            NavControl.this.scaleHandleOffsetX = dx;
            NavControl.this.scaleHandleOffsetY = 0.0;
            this.scaleDir = dx / a;
            this.scaleAcc = 1.0;
            this.fireAcceleratedScale();
            this.startTriggeringActions();
        }

        private void startTriggeringActions() {
            this.actionTrigger.restart();
        }

        private void stopTriggeringActions() {
            this.actionTrigger.stop();
        }

        private void doPan(MouseEvent e) {
            double dy;
            Point point = e.getPoint();
            double outerMoveRadius = 0.5 * NavControl.this.outerMoveCircle.getWidth();
            double dx = (double)point.x - NavControl.this.outerMoveCircle.getCenterX();
            double r = Math.sqrt(dx * dx + (dy = (double)point.y - NavControl.this.outerMoveCircle.getCenterY()) * dy);
            if (r > outerMoveRadius) {
                dx = outerMoveRadius * dx / r;
                dy = outerMoveRadius * dy / r;
            }
            NavControl.this.pannerHandleOffsetX = dx;
            NavControl.this.pannerHandleOffsetY = dy;
            this.moveDirX = -dx / outerMoveRadius;
            this.moveDirY = -dy / outerMoveRadius;
            this.moveAcc = 1.0;
            this.fireAcceleratedMove();
            this.startTriggeringActions();
        }

        void startMove(int dir) {
            this.moveDirX = X_DIRS[dir];
            this.moveDirY = Y_DIRS[dir];
            this.doMove();
        }

        private void doMove() {
            this.moveAcc = 1.0;
            this.startTriggeringActions();
        }

        private void doRotate(MouseEvent e) {
            double a1 = NavControl.this.getAngle(this.point0);
            double a2 = NavControl.this.getAngle(e.getPoint());
            double a = Math.toDegrees(NavControl.normaliseAngle(Math.toRadians(this.rotationAngle0) + (a2 - a1)));
            if (e.isControlDown()) {
                double t = 22.5;
                a = t * Math.floor(a / t);
            }
            NavControl.this.model.handleRotate(a);
            NavControl.this.repaint();
        }

        private void fireAcceleratedScale() {
            NavControl.this.model.handleScale(this.scaleAcc * this.scaleDir / 4.0);
            this.scaleAcc *= 1.1;
            if (this.scaleAcc > 4.0) {
                this.scaleAcc = 4.0;
            }
        }

        private void fireAcceleratedMove() {
            NavControl.this.model.handleMove(this.moveAcc * this.moveDirX, this.moveAcc * this.moveDirY);
            this.moveAcc *= 1.05;
            if (this.moveAcc > 4.0) {
                this.moveAcc = 4.0;
            }
        }

        private void stopAction() {
            NavControl.this.setCursor(this.cursor0);
            this.stopTriggeringActions();
            this.cursor0 = null;
            this.point0 = null;
            this.action = 0;
            this.moveDirX = 0.0;
            this.moveDirY = 0.0;
            this.moveAcc = 1.0;
            NavControl.this.pannerHandleOffsetX = 0.0;
            NavControl.this.pannerHandleOffsetY = 0.0;
            this.scaleDir = 0.0;
            this.scaleAcc = 1.0;
            NavControl.this.scaleHandleOffsetX = 0.0;
            NavControl.this.scaleHandleOffsetY = 0.0;
            NavControl.this.repaint();
        }
    }

    public static interface NavControlModel {
        public double getCurrentAngle();

        public void handleRotate(double var1);

        public void handleMove(double var1, double var3);

        public void handleScale(double var1);
    }
}

