/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.AbstractConverterTest;
import com.bc.ceres.binding.converters.DateFormatConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatConverterTest
extends AbstractConverterTest {
    private DateFormatConverter converter;
    private TimeZone oldTimeZone;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new DateFormatConverter();
        }
        return this.converter;
    }

    protected void setUp() throws Exception {
        this.oldTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
    }

    protected void tearDown() throws Exception {
        TimeZone.setDefault(this.oldTimeZone);
    }

    @Override
    public void testConverter() throws ConversionException {
        this.testValueType(Date.class);
        Date someDate = null;
        try {
            someDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2007-05-27 16:10:15");
        }
        catch (ParseException e) {
            DateFormatConverterTest.fail((String)e.getMessage());
        }
        this.testParseSuccess(new Date(0L), "1970-01-01 00:00:00");
        this.testParseSuccess(someDate, "2007-05-27 16:10:15");
        this.testParseSuccess(null, "");
        this.testFormatSuccess("1970-01-01 00:00:00", new Date(0L));
        this.testFormatSuccess("2007-05-27 16:10:15", someDate);
        this.testFormatSuccess("", null);
        this.assertNullCorrectlyHandled();
    }
}

