/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.converters.IntegerConverter;
import java.util.List;
import junit.framework.TestCase;

public class ValueSetTest
extends TestCase {
    private List<Object> objects;

    public void testParseValueSet() {
        ValueSet valueSet = null;
        try {
            valueSet = ValueSet.parseValueSet((String[])new String[]{"1", "2", "3", "5", "8"}, (Converter)new IntegerConverter());
        }
        catch (ConversionException e) {
            ValueSetTest.fail();
        }
        ValueSetTest.assertNotNull((Object)valueSet.getItems());
        ValueSetTest.assertEquals((int)5, (int)valueSet.getItems().length);
        ValueSetTest.assertEquals((Object)1, (Object)valueSet.getItems()[0]);
        ValueSetTest.assertEquals((Object)2, (Object)valueSet.getItems()[1]);
        ValueSetTest.assertEquals((Object)3, (Object)valueSet.getItems()[2]);
        ValueSetTest.assertEquals((Object)5, (Object)valueSet.getItems()[3]);
        ValueSetTest.assertEquals((Object)8, (Object)valueSet.getItems()[4]);
        try {
            ValueSet.parseValueSet((String[])new String[]{"1", "Foo", "3", "5", "8"}, (Converter)new IntegerConverter());
            ValueSetTest.fail();
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testContains() {
        ValueSet valueSet = new ValueSet((Object[])new Integer[]{1, 2, 3, 5, 8});
        ValueSetTest.assertEquals((boolean)true, (boolean)valueSet.contains((Object)1));
        ValueSetTest.assertEquals((boolean)true, (boolean)valueSet.contains((Object)2));
        ValueSetTest.assertEquals((boolean)true, (boolean)valueSet.contains((Object)3));
        ValueSetTest.assertEquals((boolean)true, (boolean)valueSet.contains((Object)5));
        ValueSetTest.assertEquals((boolean)true, (boolean)valueSet.contains((Object)8));
        ValueSetTest.assertEquals((boolean)false, (boolean)valueSet.contains((Object)-1));
        ValueSetTest.assertEquals((boolean)false, (boolean)valueSet.contains((Object)0));
        ValueSetTest.assertEquals((boolean)false, (boolean)valueSet.contains((Object)4));
        ValueSetTest.assertEquals((boolean)false, (boolean)valueSet.contains((Object)9));
    }
}

