/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.PropertyDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class PropertyDescriptorTest {
    @Test
    public void testMandatoryNameAndType() {
        PropertyDescriptor descriptor = new PropertyDescriptor("wasIstDasDenn", String.class);
        Assert.assertEquals((Object)"wasIstDasDenn", (Object)descriptor.getName());
        Assert.assertEquals((Object)"Was ist das denn", (Object)descriptor.getDisplayName());
        Assert.assertSame(String.class, (Object)descriptor.getType());
        descriptor = new PropertyDescriptor("was_ist_das_denn", Double.TYPE);
        Assert.assertEquals((Object)"was_ist_das_denn", (Object)descriptor.getName());
        Assert.assertEquals((Object)"Was ist das denn", (Object)descriptor.getDisplayName());
        Assert.assertSame(Double.TYPE, (Object)descriptor.getType());
        descriptor.setDisplayName("Was denn");
        Assert.assertEquals((Object)"Was denn", (Object)descriptor.getDisplayName());
        try {
            descriptor.setDisplayName(null);
            Assert.fail((String)"NPE expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testThatPrimitiveTypesAreAlwaysNotNull() {
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Character.TYPE, Character.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Byte.TYPE, Byte.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Short.TYPE, Short.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Integer.TYPE, Integer.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Long.TYPE, Long.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Float.TYPE, Float.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Double.TYPE, Double.class);
        PropertyDescriptorTest.assertThatPrimitiveTypesAreAlwaysNotNull(Void.TYPE, Void.class);
    }

    private static void assertThatPrimitiveTypesAreAlwaysNotNull(Class<?> primitiveType, Class<?> wrapperType) {
        Assert.assertEquals((Object)true, (Object)new PropertyDescriptor("vd", primitiveType).isNotNull());
        Assert.assertEquals((Object)false, (Object)new PropertyDescriptor("vd", wrapperType).isNotNull());
    }

    @Test
    public void testThatEnumTypesHaveValueSet() {
        PropertyDescriptor descriptor = new PropertyDescriptor("letter", Letter.class);
        Assert.assertNotNull((Object)descriptor.getValueSet());
        Assert.assertArrayEquals((Object[])new Object[]{Letter.A, Letter.B, Letter.C, Letter.D}, (Object[])descriptor.getValueSet().getItems());
    }

    public static enum Letter {
        A,
        B,
        C,
        D;

    }
}

