/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.validators.MultiValidator;
import com.bc.ceres.binding.validators.NotNullValidator;
import com.bc.ceres.binding.validators.TypeValidator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;

public class PropertyTest
extends TestCase {
    private static final long LEGAL_PLONG = 999L;
    private static final Long LEGAL_OLONG = 999L;
    private static final String ILLEGAL = "42";
    private static final float FLOAT_EPS = 1.0E-4f;
    private static final double DOUBLE_EPS = 1.0E-10;
    private static final String MODE_ACCURATE = "acc";
    private static final String MODE_FUZZY = "fuz";
    long plong;
    Long olong;
    float pfloat;
    Float ofloat;
    double pdouble;
    Double odouble;

    public void testFactoryUsingClassFieldAccessor() throws ValidationException {
        this.testPLong(Property.createForField((Object)((Object)this), (String)"plong"), 0L);
        this.testOLong(Property.createForField((Object)((Object)this), (String)"olong"), null);
        PropertyTest.assertEquals((long)999L, (long)this.plong);
        PropertyTest.assertEquals((Object)LEGAL_OLONG, (Object)this.olong);
        this.testPLong(Property.createForField((Object)((Object)this), (String)"plong", (Object)42L), 42L);
        this.testOLong(Property.createForField((Object)((Object)this), (String)"olong", (Object)43L), 43L);
        PropertyTest.assertEquals((long)999L, (long)this.plong);
        PropertyTest.assertEquals((Object)LEGAL_OLONG, (Object)this.olong);
    }

    public void testFactoryUsingMapEntryAccessor() throws ValidationException {
        HashMap map = new HashMap();
        this.testPLong(Property.createForMapEntry(map, (String)"plong", Long.TYPE), 0L);
        this.testOLong(Property.createForMapEntry(map, (String)"olong", Long.class), null);
        PropertyTest.assertEquals((Object)LEGAL_OLONG, map.get("plong"));
        PropertyTest.assertEquals((Object)LEGAL_OLONG, map.get("olong"));
        this.testPLong(Property.createForMapEntry(map, (String)"plong", Long.TYPE, (Object)42L), 42L);
        this.testOLong(Property.createForMapEntry(map, (String)"olong", Long.class, (Object)43L), 43L);
        PropertyTest.assertEquals((Object)LEGAL_OLONG, map.get("plong"));
        PropertyTest.assertEquals((Object)LEGAL_OLONG, map.get("olong"));
    }

    public void testDefaultFactoryWithType() throws ValidationException {
        this.testPLong(Property.create((String)"plong", Long.TYPE), 0L);
        this.testOLong(Property.create((String)"olong", Long.class), null);
        this.testOLong(Property.create((String)"olong", (Object)42L), 42L);
    }

    private void testPLong(Property vm, Object expectedValue) throws ValidationException {
        PropertyTest.assertNotNull((Object)vm.getDescriptor());
        PropertyTest.assertEquals((String)"plong", (String)vm.getDescriptor().getName());
        PropertyTest.assertSame(Long.TYPE, (Object)vm.getDescriptor().getType());
        PropertyTest.assertEquals((boolean)true, (boolean)vm.getDescriptor().isNotNull());
        PropertyTest.assertNotNull((Object)vm.getDescriptor().getConverter());
        PropertyTest.assertSame(MultiValidator.class, vm.getValidator().getClass());
        Validator[] validators = ((MultiValidator)vm.getValidator()).getValidators();
        PropertyTest.assertEquals((int)2, (int)validators.length);
        PropertyTest.assertSame(NotNullValidator.class, validators[0].getClass());
        PropertyTest.assertSame(TypeValidator.class, validators[1].getClass());
        PropertyTest.assertTrue((boolean)(vm.getValue() instanceof Long));
        PropertyTest.assertEquals((Object)expectedValue, (Object)vm.getValue());
        this.testSetLegalValue(vm);
        this.testSetIllegalValue(vm);
    }

    private void testOLong(Property vm, Object expectedValue) throws ValidationException {
        PropertyTest.assertNotNull((Object)vm.getDescriptor());
        PropertyTest.assertEquals((String)"olong", (String)vm.getDescriptor().getName());
        PropertyTest.assertEquals((boolean)false, (boolean)vm.getDescriptor().isNotNull());
        PropertyTest.assertSame(Long.class, (Object)vm.getDescriptor().getType());
        PropertyTest.assertNotNull((Object)vm.getDescriptor().getConverter());
        PropertyTest.assertSame(TypeValidator.class, vm.getValidator().getClass());
        PropertyTest.assertEquals((Object)expectedValue, (Object)vm.getValue());
        this.testSetLegalValue(vm);
        this.testSetIllegalValue(vm);
    }

    private void testSetLegalValue(Property vm) throws ValidationException {
        vm.setValue((Object)LEGAL_OLONG);
        PropertyTest.assertEquals((Object)LEGAL_OLONG, (Object)vm.getValue());
    }

    private void testSetIllegalValue(Property property) {
        try {
            property.setValue((Object)ILLEGAL);
            PropertyTest.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testPropertyChangeEvents() throws ValidationException {
        Property plong = Property.createForField((Object)((Object)this), (String)"plong");
        Property olong = Property.createForField((Object)((Object)this), (String)"olong");
        Property pfloat = Property.createForField((Object)((Object)this), (String)"pfloat");
        Property ofloat = Property.createForField((Object)((Object)this), (String)"ofloat");
        Property pdouble = Property.createForField((Object)((Object)this), (String)"pdouble");
        Property odouble = Property.createForField((Object)((Object)this), (String)"odouble");
        PropertyContainer container = new PropertyContainer();
        ValueModelChangeListener listener = new ValueModelChangeListener();
        container.addPropertyChangeListener((PropertyChangeListener)listener);
        container.addProperty(plong);
        container.addProperty(olong);
        container.addProperty(pfloat);
        container.addProperty(ofloat);
        container.addProperty(pdouble);
        container.addProperty(odouble);
        this.testPCLLong(plong, listener);
        this.testPCLLong(olong, listener);
        this.testPCLFloat(pfloat, listener, MODE_ACCURATE);
        this.testPCLFloat(ofloat, listener, MODE_ACCURATE);
        this.testPCLDouble(pdouble, listener, MODE_ACCURATE);
        this.testPCLDouble(odouble, listener, MODE_ACCURATE);
        pfloat.getDescriptor().setAttribute("eps", (Object)Float.valueOf(1.0E-4f));
        ofloat.getDescriptor().setAttribute("eps", (Object)Float.valueOf(1.0E-4f));
        pdouble.getDescriptor().setAttribute("eps", (Object)1.0E-10);
        odouble.getDescriptor().setAttribute("eps", (Object)1.0E-10);
        this.testPCLLong(plong, listener);
        this.testPCLLong(olong, listener);
        this.testPCLFloat(pfloat, listener, MODE_FUZZY);
        this.testPCLFloat(ofloat, listener, MODE_FUZZY);
        this.testPCLDouble(pdouble, listener, MODE_FUZZY);
        this.testPCLDouble(odouble, listener, MODE_FUZZY);
    }

    private void testPCLLong(Property model, ValueModelChangeListener listener) throws ValidationException {
        int n0 = listener.events.size();
        model.setValue((Object)1L);
        PropertyTest.assertEquals((int)1, (int)(listener.events.size() - n0));
        model.setValue((Object)1L);
        PropertyTest.assertEquals((int)1, (int)(listener.events.size() - n0));
        model.setValue((Object)2L);
        PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
    }

    private void testPCLFloat(Property model, ValueModelChangeListener listener, String mode) throws ValidationException {
        int n0 = listener.events.size();
        model.setValue((Object)Float.valueOf(1.0f));
        PropertyTest.assertEquals((int)1, (int)(listener.events.size() - n0));
        model.setValue((Object)Float.valueOf(1.0f));
        PropertyTest.assertEquals((int)1, (int)(listener.events.size() - n0));
        model.setValue((Object)Float.valueOf(2.0f));
        PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
        if (mode.equals(MODE_FUZZY)) {
            model.setValue((Object)Float.valueOf(1.999901f));
            PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
            model.setValue((Object)Float.valueOf(2.000099f));
            PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
        } else {
            model.setValue((Object)Float.valueOf(1.999901f));
            PropertyTest.assertEquals((int)3, (int)(listener.events.size() - n0));
            model.setValue((Object)Float.valueOf(2.000099f));
            PropertyTest.assertEquals((int)4, (int)(listener.events.size() - n0));
        }
    }

    private void testPCLDouble(Property model, ValueModelChangeListener listener, String mode) throws ValidationException {
        int n0 = listener.events.size();
        model.setValue((Object)1.0);
        PropertyTest.assertEquals((int)1, (int)(listener.events.size() - n0));
        model.setValue((Object)1.0);
        PropertyTest.assertEquals((int)1, (int)(listener.events.size() - n0));
        model.setValue((Object)2.0);
        PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
        if (mode.equals(MODE_FUZZY)) {
            model.setValue((Object)1.999999999901);
            PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
            model.setValue((Object)2.000000000099);
            PropertyTest.assertEquals((int)2, (int)(listener.events.size() - n0));
        } else {
            model.setValue((Object)1.999999999901);
            PropertyTest.assertEquals((int)3, (int)(listener.events.size() - n0));
            model.setValue((Object)2.000000000099);
            PropertyTest.assertEquals((int)4, (int)(listener.events.size() - n0));
        }
    }

    private static class ValueModelChangeListener
    implements PropertyChangeListener {
        ArrayList<PropertyChangeEvent> events = new ArrayList();

        private ValueModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            this.events.add(event);
        }
    }
}

