/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos;

import com.bc.ceres.binio.CompoundData;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.esa.smos.DateTimeUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DateTimeUtilsTest {
    @Test
    public void testCfiDateToUtc() {
        Date date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)0L);
        Assert.assertEquals((Object)"Sat Jan 01 01:00:00 CET 2000", (Object)date.toString());
        date = DateTimeUtils.cfiDateToUtc((int)1, (long)0L, (long)0L);
        Assert.assertEquals((Object)"Sun Jan 02 01:00:00 CET 2000", (Object)date.toString());
        date = DateTimeUtils.cfiDateToUtc((int)1, (long)10L, (long)0L);
        long timeWithoutMillis = date.getTime();
        Assert.assertEquals((Object)"Sun Jan 02 01:00:10 CET 2000", (Object)date.toString());
        date = DateTimeUtils.cfiDateToUtc((int)1, (long)10L, (long)100000L);
        Assert.assertEquals((Object)"Sun Jan 02 01:00:10 CET 2000", (Object)date.toString());
        Assert.assertEquals((long)(timeWithoutMillis + 100L), (long)date.getTime());
    }

    @Test
    public void testCfiDateToUtc_formCompound() throws IOException {
        CompoundData compoundData = (CompoundData)Mockito.mock(CompoundData.class);
        Mockito.when((Object)compoundData.getInt("Days")).thenReturn((Object)187);
        Mockito.when((Object)compoundData.getUInt("Seconds")).thenReturn((Object)78765L);
        Mockito.when((Object)compoundData.getUInt("Microseconds")).thenReturn((Object)1007L);
        Date date = DateTimeUtils.cfiDateToUtc((CompoundData)compoundData);
        Assert.assertEquals((Object)"Thu Jul 06 23:52:45 CEST 2000", (Object)date.toString());
        Mockito.when((Object)compoundData.getInt("Days")).thenReturn((Object)0);
        Mockito.when((Object)compoundData.getUInt("Seconds")).thenReturn((Object)0L);
        Mockito.when((Object)compoundData.getUInt("Microseconds")).thenReturn((Object)0L);
        date = DateTimeUtils.cfiDateToUtc((CompoundData)compoundData);
        Assert.assertEquals((Object)"Sat Jan 01 01:00:00 CET 2000", (Object)date.toString());
    }

    @Test
    public void testMjdFloatDateToUtc() {
        Date date = DateTimeUtils.mjdFloatDateToUtc((float)0.0f);
        Assert.assertEquals((Object)"Sat Jan 01 01:00:00 CET 2000", (Object)date.toString());
        date = DateTimeUtils.mjdFloatDateToUtc((float)1.0f);
        Assert.assertEquals((Object)"Sun Jan 02 01:00:00 CET 2000", (Object)date.toString());
        date = DateTimeUtils.mjdFloatDateToUtc((float)1.0001158f);
        long timeWithoutMillis = date.getTime();
        Assert.assertEquals((Object)"Sun Jan 02 01:00:10 CET 2000", (Object)date.toString());
        date = DateTimeUtils.mjdFloatDateToUtc((float)1.000117f);
        Assert.assertEquals((Object)"Sun Jan 02 01:00:10 CET 2000", (Object)date.toString());
        Assert.assertEquals((long)(timeWithoutMillis + 103L), (long)date.getTime());
    }

    @Test
    public void testToVariableHeaderFormat() {
        Date date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)0L);
        String variableHeaderFormat = DateTimeUtils.toVariableHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-01T00:00:00.000000", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)1, (long)0L, (long)0L);
        variableHeaderFormat = DateTimeUtils.toVariableHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-02T00:00:00.000000", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)0, (long)1L, (long)0L);
        variableHeaderFormat = DateTimeUtils.toVariableHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-01T00:00:01.000000", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)1000L);
        variableHeaderFormat = DateTimeUtils.toVariableHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-01T00:00:00.000001", (Object)variableHeaderFormat);
    }

    @Test
    public void testToFixedHeaderFormat() {
        Date date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)0L);
        String variableHeaderFormat = DateTimeUtils.toFixedHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-01T00:00:00", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)1, (long)0L, (long)0L);
        variableHeaderFormat = DateTimeUtils.toFixedHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-02T00:00:00", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)0, (long)1L, (long)0L);
        variableHeaderFormat = DateTimeUtils.toFixedHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-01T00:00:01", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)1000L);
        variableHeaderFormat = DateTimeUtils.toFixedHeaderFormat((Date)date);
        Assert.assertEquals((Object)"UTC=2000-01-01T00:00:00", (Object)variableHeaderFormat);
    }

    @Test
    public void testFromFixedHeaderFormat() throws ParseException {
        Date date = DateTimeUtils.fromFixedHeaderFormat((String)"UTC=2000-01-01T00:00:00");
        Assert.assertEquals((long)946684800000L, (long)date.getTime());
        date = DateTimeUtils.fromFixedHeaderFormat((String)"UTC=2000-01-01T00:00:01");
        Assert.assertEquals((long)946684801000L, (long)date.getTime());
    }

    @Test
    public void testToFileNameFormat() {
        Date date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)0L);
        String variableHeaderFormat = DateTimeUtils.toFileNameFormat((Date)date);
        Assert.assertEquals((Object)"20000101T000000", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)1, (long)0L, (long)0L);
        variableHeaderFormat = DateTimeUtils.toFileNameFormat((Date)date);
        Assert.assertEquals((Object)"20000102T000000", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)0, (long)1L, (long)0L);
        variableHeaderFormat = DateTimeUtils.toFileNameFormat((Date)date);
        Assert.assertEquals((Object)"20000101T000001", (Object)variableHeaderFormat);
        date = DateTimeUtils.cfiDateToUtc((int)0, (long)0L, (long)1000L);
        variableHeaderFormat = DateTimeUtils.toFileNameFormat((Date)date);
        Assert.assertEquals((Object)"20000101T000000", (Object)variableHeaderFormat);
    }

    @Test
    public void testGetUtcCalendar() {
        Calendar calendar = DateTimeUtils.getUtcCalendar();
        Assert.assertNotNull((Object)calendar);
        Assert.assertEquals((Object)"UTC", (Object)calendar.getTimeZone().getID());
    }
}

