/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.smos;

import com.bc.ceres.binio.CompoundData;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeUtils {
    private static final TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat VARIABLE_HEADER_FORMAT = new SimpleDateFormat("'UTC='yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
    private static final SimpleDateFormat FIXED_HEADER_FORMAT = new SimpleDateFormat("'UTC='yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat FILE_NAME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss");

    public static Calendar getUtcCalendar() {
        return new GregorianCalendar(TIME_ZONE_UTC);
    }

    public static Date cfiDateToUtc(int days, long seconds, long microseconds) {
        Calendar calendar = DateTimeUtils.getUtcCalendar();
        calendar.set(1, 2000);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, days);
        calendar.add(13, (int)seconds);
        calendar.add(14, (int)((double)microseconds * 0.001));
        return calendar.getTime();
    }

    public static Date cfiDateToUtc(CompoundData compoundData) throws IOException {
        int days = compoundData.getInt("Days");
        long seconds = compoundData.getUInt("Seconds");
        long microSeconds = compoundData.getUInt("Microseconds");
        return DateTimeUtils.cfiDateToUtc(days, seconds, microSeconds);
    }

    public static Date mjdFloatDateToUtc(float mjd) {
        int days = (int)mjd;
        double secondsFraction = (double)(mjd - (float)days) * 86400.0;
        int seconds = (int)secondsFraction;
        int microseconds = (int)((secondsFraction - (double)seconds) * 1000000.0);
        return DateTimeUtils.cfiDateToUtc(days, seconds, microseconds);
    }

    public static String toVariableHeaderFormat(Date date) {
        return VARIABLE_HEADER_FORMAT.format(date);
    }

    public static String toFixedHeaderFormat(Date date) {
        return FIXED_HEADER_FORMAT.format(date);
    }

    public static Date fromFixedHeaderFormat(String dateString) throws ParseException {
        return FIXED_HEADER_FORMAT.parse(dateString);
    }

    public static String toFileNameFormat(Date date) {
        return FILE_NAME_FORMAT.format(date);
    }

    static {
        VARIABLE_HEADER_FORMAT.setTimeZone(TIME_ZONE_UTC);
        FIXED_HEADER_FORMAT.setTimeZone(TIME_ZONE_UTC);
        FILE_NAME_FORMAT.setTimeZone(TIME_ZONE_UTC);
    }
}

