/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.smos;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.esa.beam.dataio.smos.PointList;

public class DggUtils {
    public static Area computeArea(PointList pointList) throws IOException {
        Rectangle2D[] tileRectangles = new Rectangle2D[512];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 16; ++j) {
                tileRectangles[i * 16 + j] = DggUtils.createTileRectangle(i, j);
            }
        }
        Area envelope = new Area();
        block2: for (int i = 0; i < pointList.getElementCount(); ++i) {
            double lon = pointList.getLon(i);
            double lat = pointList.getLat(i);
            if (lon > 180.0) {
                lon -= 360.0;
            }
            double hw = 0.02;
            double hh = 0.02;
            double x = lon - 0.02;
            double y = lat - 0.02;
            double w = 0.04;
            double h = 0.04;
            if (envelope.contains(x, y, 0.04, 0.04)) continue;
            for (Rectangle2D tileRectangle : tileRectangles) {
                if (!tileRectangle.intersects(x, y, 0.04, 0.04) || envelope.contains(tileRectangle)) continue;
                envelope.add(new Area(tileRectangle));
                if (envelope.contains(x, y, 0.04, 0.04)) continue block2;
            }
        }
        return envelope;
    }

    static Rectangle2D createTileRectangle(int i, int j) {
        double w = 11.25;
        double h = 11.07421875;
        double x = 11.25 * (double)i - 180.0;
        double y = 88.59375 - 11.07421875 * (double)(j + 1);
        return new Rectangle2D.Double(x, y, 11.25, 11.07421875);
    }

    public static Rectangle2D createGridPointRectangle(double lon, double lat) {
        if ((lon -= 0.02) < -180.0) {
            lon = -180.0;
        } else if (lon + 0.04 > 180.0) {
            lon -= 0.04;
        }
        lat -= 0.01;
        if (lat < -90.0) {
            lat = -90.0;
        } else if (lat + 0.02 > 90.0) {
            lat -= 0.02;
        }
        return new Rectangle2D.Double(lon, lat, 0.04, 0.02);
    }
}

