/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.provider;

import com.bc.ceres.binio.CompoundData;
import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.DggFile;
import org.esa.smos.dataio.smos.provider.DefaultValueProvider;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultValueProviderTest {
    private DggFile dggFile;
    private DefaultValueProvider defaultValueProvider;
    private CompoundData compoundData;

    @Before
    public void setUp() {
        this.dggFile = (DggFile)Mockito.mock(DggFile.class);
        this.compoundData = (CompoundData)Mockito.mock(CompoundData.class);
        this.defaultValueProvider = new DefaultValueProvider(this.dggFile, 12);
    }

    @Test
    public void testGetArea() {
        Mockito.when((Object)this.dggFile.getArea()).thenReturn((Object)new Area());
        this.defaultValueProvider.getArea();
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getArea();
    }

    @Test
    public void testGetGridPointIndex() {
        Mockito.when((Object)this.dggFile.getGridPointIndex(Mockito.anyInt())).thenReturn((Object)34);
        this.defaultValueProvider.getGridPointIndex(45);
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getGridPointIndex(Mockito.anyInt());
    }

    @Test
    public void testGetByte() throws IOException {
        Mockito.when((Object)this.dggFile.getGridPointData(Mockito.anyInt())).thenReturn((Object)this.compoundData);
        Mockito.when((Object)this.compoundData.getByte(Mockito.anyInt())).thenReturn((Object)new Byte("1"));
        this.defaultValueProvider.getByte(45);
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getGridPointData(45);
        ((CompoundData)Mockito.verify((Object)this.compoundData, (VerificationMode)Mockito.times((int)1))).getByte(Mockito.anyInt());
    }

    @Test
    public void testGetShort() throws IOException {
        Mockito.when((Object)this.dggFile.getGridPointData(Mockito.anyInt())).thenReturn((Object)this.compoundData);
        Mockito.when((Object)this.compoundData.getShort(Mockito.anyInt())).thenReturn((Object)new Short("4"));
        this.defaultValueProvider.getShort(46);
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getGridPointData(46);
        ((CompoundData)Mockito.verify((Object)this.compoundData, (VerificationMode)Mockito.times((int)1))).getShort(Mockito.anyInt());
    }

    @Test
    public void testGetInt() throws IOException {
        Mockito.when((Object)this.dggFile.getGridPointData(Mockito.anyInt())).thenReturn((Object)this.compoundData);
        Mockito.when((Object)this.compoundData.getInt(Mockito.anyInt())).thenReturn((Object)5);
        this.defaultValueProvider.getInt(47);
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getGridPointData(47);
        ((CompoundData)Mockito.verify((Object)this.compoundData, (VerificationMode)Mockito.times((int)1))).getInt(Mockito.anyInt());
    }

    @Test
    public void testGetLong() throws IOException {
        Mockito.when((Object)this.dggFile.getGridPointData(Mockito.anyInt())).thenReturn((Object)this.compoundData);
        Mockito.when((Object)this.compoundData.getLong(Mockito.anyInt())).thenReturn((Object)6L);
        this.defaultValueProvider.getLong(48);
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getGridPointData(48);
        ((CompoundData)Mockito.verify((Object)this.compoundData, (VerificationMode)Mockito.times((int)1))).getLong(Mockito.anyInt());
    }

    @Test
    public void testGetFloat() throws IOException {
        Mockito.when((Object)this.dggFile.getGridPointData(Mockito.anyInt())).thenReturn((Object)this.compoundData);
        Mockito.when((Object)Float.valueOf(this.compoundData.getFloat(Mockito.anyInt()))).thenReturn((Object)Float.valueOf(7.0f));
        this.defaultValueProvider.getFloat(49);
        ((DggFile)Mockito.verify((Object)this.dggFile, (VerificationMode)Mockito.times((int)1))).getGridPointData(49);
        ((CompoundData)Mockito.verify((Object)this.compoundData, (VerificationMode)Mockito.times((int)1))).getFloat(Mockito.anyInt());
    }
}

