/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dffg;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.util.DataPrinter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dffg.DffgLaiFile;
import org.junit.Assert;
import org.junit.Test;

public class DffgLaiFileTest {
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final File DATA_DIR = new File(USER_HOME, "SM_OPER_AUX_DFFLAI_20091219T000000_20100118T000000_306_001_3");
    private static final File DBL_FILE = new File(DATA_DIR, "SM_OPER_AUX_DFFLAI_20091219T000000_20100118T000000_306_001_3.DBL");
    private static final File HDR_FILE = new File(DATA_DIR, "SM_OPER_AUX_DFFLAI_20091219T000000_20100118T000000_306_001_3.HDR");
    private static final String DFFG_LAI_NAME = "DFFG_LAI";
    private static final int ZONE_COUNT = 74;

    @Test
    public void format() throws IOException {
        if (HDR_FILE.exists()) {
            DataFormat dataFormat = Dddb.getInstance().getDataFormat(HDR_FILE);
            CompoundType dataBlockType = dataFormat.getType();
            Assert.assertEquals((long)1L, (long)dataBlockType.getMemberCount());
            Assert.assertEquals((long)0L, (long)dataBlockType.getMemberIndex(DFFG_LAI_NAME));
            Type zoneSequenceDataType = dataBlockType.getMember(0).getType();
            Assert.assertTrue((boolean)zoneSequenceDataType.isSequenceType());
            SequenceType sequenceType = (SequenceType)zoneSequenceDataType;
            Assert.assertEquals((long)74L, (long)sequenceType.getElementCount());
        }
    }

    @Test
    public void testZoneDataSizes() throws IOException {
        if (HDR_FILE.exists() && DBL_FILE.exists()) {
            DataFormat dataFormat = Dddb.getInstance().getDataFormat(HDR_FILE);
            DffgLaiFile laiFile = new DffgLaiFile(new EEFilePair(HDR_FILE, DBL_FILE), dataFormat.createContext(DBL_FILE, "r"));
            SequenceData sequenceData = laiFile.getDataBlock().getSequence(DFFG_LAI_NAME);
            Assert.assertEquals((long)74L, (long)sequenceData.getElementCount());
            CompoundData compoundData = sequenceData.getCompound(0);
            Assert.assertEquals((long)0L, (long)compoundData.getPosition());
            compoundData.resolveSize();
            Assert.assertEquals((long)3791314L, (long)compoundData.getSize());
            compoundData = sequenceData.getCompound(1);
            Assert.assertEquals((long)3791314L, (long)compoundData.getPosition());
            compoundData.resolveSize();
            Assert.assertEquals((long)3791314L, (long)compoundData.getSize());
            compoundData = sequenceData.getCompound(2);
            compoundData.resolveSize();
            Assert.assertEquals((long)3052488L, (long)compoundData.getSize());
            compoundData = sequenceData.getCompound(3);
            compoundData.resolveSize();
            Assert.assertEquals((long)3052488L, (long)compoundData.getSize());
            laiFile.getCellIndex(0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        DataFormat dataFormat = Dddb.getInstance().getDataFormat(HDR_FILE);
        DffgLaiFile explorerFile = new DffgLaiFile(new EEFilePair(HDR_FILE, DBL_FILE), dataFormat.createContext(DBL_FILE, "r"));
        SequenceData sequenceData = explorerFile.getDataBlock().getSequence(DFFG_LAI_NAME);
        try {
            int i = sequenceData.getElementCount();
            while (i-- > 0) {
                int zoneId = sequenceData.getCompound(i).getInt("Zone_ID");
                String fileName = DBL_FILE.getName().replace("DBL", zoneId + ".TXT");
                File file = new File(DATA_DIR, fileName);
                PrintStream printStream = new PrintStream(file);
                DataPrinter dataPrinter = new DataPrinter(printStream, false);
                try {
                    dataPrinter.print((CollectionData)sequenceData.getCompound(i));
                }
                finally {
                    printStream.close();
                }
            }
        }
        finally {
            explorerFile.close();
        }
    }
}

