/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.awt.Color;
import org.esa.smos.dataio.smos.dddb.TokenParser;
import org.junit.Assert;
import org.junit.Test;

public class TokenParserTest {
    @Test
    public void testParseStringWithDefault() {
        Assert.assertEquals((Object)"hulperitz", (Object)TokenParser.parseString((String)"hulperitz", (String)"schnack"));
        Assert.assertEquals((Object)"bla", (Object)TokenParser.parseString((String)" bla ", (String)"blo"));
        Assert.assertEquals((Object)"default", (Object)TokenParser.parseString((String)"*", (String)"default"));
        Assert.assertEquals((Object)"de-fault", (Object)TokenParser.parseString((String)" * ", (String)"de-fault"));
    }

    @Test
    public void testParseString() {
        Assert.assertEquals((Object)"value", (Object)TokenParser.parseString((String)"value"));
        Assert.assertEquals((Object)"hoppla", (Object)TokenParser.parseString((String)" hoppla "));
    }

    @Test
    public void testParseIntWithDefault() {
        Assert.assertEquals((long)19L, (long)TokenParser.parseInt((String)"19", (int)108));
        Assert.assertEquals((long)20L, (long)TokenParser.parseInt((String)" 20 ", (int)109));
        Assert.assertEquals((long)110L, (long)TokenParser.parseInt((String)"*", (int)110));
        Assert.assertEquals((long)111L, (long)TokenParser.parseInt((String)" * ", (int)111));
    }

    @Test
    public void testParseHexWithDefault() {
        Assert.assertEquals((long)33L, (long)TokenParser.parseHex((String)"21", (int)112));
        Assert.assertEquals((long)34L, (long)TokenParser.parseHex((String)" 22 ", (int)113));
        Assert.assertEquals((long)114L, (long)TokenParser.parseHex((String)"*", (int)114));
        Assert.assertEquals((long)115L, (long)TokenParser.parseHex((String)" * ", (int)115));
    }

    @Test
    public void testParseDoubleWithDefault() {
        Assert.assertEquals((double)23.4, (double)TokenParser.parseDouble((String)"23.4", (double)116.0), (double)1.0E-8);
        Assert.assertEquals((double)23.5, (double)TokenParser.parseDouble((String)" 23.5 ", (double)117.0), (double)1.0E-8);
        Assert.assertEquals((double)118.9, (double)TokenParser.parseDouble((String)"*", (double)118.9), (double)1.0E-8);
        Assert.assertEquals((double)119.1, (double)TokenParser.parseDouble((String)" * ", (double)119.1), (double)1.0E-8);
    }

    @Test
    public void testParseColorWithDefault() {
        Color color = TokenParser.parseColor((String)"7766343", (Color)Color.BLACK);
        Assert.assertEquals((Object)"java.awt.Color[r=118,g=99,b=67]", (Object)color.toString());
        color = TokenParser.parseColor((String)" 7766344 ", (Color)Color.BLUE);
        Assert.assertEquals((Object)"java.awt.Color[r=118,g=99,b=68]", (Object)color.toString());
        color = TokenParser.parseColor((String)"*", (Color)Color.CYAN);
        Assert.assertEquals((Object)Color.CYAN, (Object)color);
        color = TokenParser.parseColor((String)" * ", (Color)Color.DARK_GRAY);
        Assert.assertEquals((Object)Color.DARK_GRAY, (Object)color);
    }

    @Test
    public void testParseBooleanWithDefault() {
        Assert.assertTrue((boolean)TokenParser.parseBoolean((String)"true", (boolean)false));
        Assert.assertFalse((boolean)TokenParser.parseBoolean((String)" false ", (boolean)true));
        Assert.assertTrue((boolean)TokenParser.parseBoolean((String)"*", (boolean)true));
        Assert.assertFalse((boolean)TokenParser.parseBoolean((String)" * ", (boolean)false));
    }
}

