/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Properties;
import org.esa.smos.dataio.smos.dddb.ResourceHandler;
import org.esa.snap.core.util.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceHandlerTest {
    private ResourceHandler resourceHandler;

    @Before
    public void setUp() {
        this.resourceHandler = new ResourceHandler();
    }

    @Test
    public void testBuildPath() {
        String path = ResourceHandler.buildPath((String)"DBL_SM_XXXX_MIR_SMDAP2_0300", (String)"flags", (String)".csv");
        Assert.assertEquals((Object)"flags/MIR_/SMDAP2/DBL_SM_XXXX_MIR_SMDAP2_0300.csv", (Object)path);
        path = ResourceHandler.buildPath((String)"DBL_SM_XXXX_MIR_BWLF1C_0300", (String)"schemas", (String)".binXschema.xml");
        Assert.assertEquals((Object)"schemas/MIR_/BWLF1C/DBL_SM_XXXX_MIR_BWLF1C_0300.binXschema.xml", (Object)path);
    }

    @Test
    public void testGetResourceStream_fromJar() throws IOException {
        System.clearProperty("org.esa.smos.dddbDir");
        InputStream resourceStream = this.resourceHandler.getResourceStream("bands/AUX_/DFFLAI/DBL_SM_XXXX_AUX_DFFLAI_0200.csv");
        Assert.assertNotNull((Object)resourceStream);
        resourceStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResourceStream_fromDirectory() throws IOException {
        String testFileName = "test_me";
        File targetDirectory = null;
        InputStream resourceStream = null;
        try {
            targetDirectory = this.createTestDirectory();
            System.setProperty("org.esa.smos.dddbDir", targetDirectory.getAbsolutePath());
            this.createTestFile(targetDirectory, "test_me");
            resourceStream = this.resourceHandler.getResourceStream("test_me");
            Assert.assertNotNull((Object)resourceStream);
        }
        finally {
            if (resourceStream != null) {
                resourceStream.close();
            }
            System.clearProperty("org.esa.smos.dddbDir");
            if (targetDirectory != null && targetDirectory.isDirectory() && !FileUtils.deleteTree((File)targetDirectory)) {
                Assert.fail((String)"Unable to delete test directory");
            }
        }
    }

    @Test
    public void testGetResourceURL_fromJar() throws IOException {
        System.clearProperty("org.esa.smos.dddbDir");
        String resourcePath = "bands/AUX_/DGGFLO/DBL_SM_XXXX_AUX_DGGFLO_0400.csv";
        URL resourceUrl = this.resourceHandler.getResourceUrl("bands/AUX_/DGGFLO/DBL_SM_XXXX_AUX_DGGFLO_0400.csv");
        Assert.assertNotNull((Object)resourceUrl);
        Assert.assertThat((Object)resourceUrl.getPath(), (Matcher)CoreMatchers.containsString((String)"bands/AUX_/DGGFLO/DBL_SM_XXXX_AUX_DGGFLO_0400.csv"));
        Assert.assertEquals((Object)"file", (Object)resourceUrl.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResourceURL_fromDirectory() throws IOException {
        File targetDirectory = null;
        try {
            targetDirectory = this.createTestDirectory();
            String absoluteTargetPath = targetDirectory.getAbsolutePath();
            System.setProperty("org.esa.smos.dddbDir", absoluteTargetPath);
            File targetFile = new File(targetDirectory, "wurst");
            if (!targetFile.createNewFile()) {
                Assert.fail((String)"unable to create test file");
            }
            URL resourceUrl = this.resourceHandler.getResourceUrl("wurst");
            Assert.assertNotNull((Object)resourceUrl);
            Assert.assertEquals((Object)"file", (Object)resourceUrl.getProtocol());
            Assert.assertTrue((boolean)new File(resourceUrl.getFile()).isFile());
        }
        finally {
            System.clearProperty("org.esa.smos.dddbDir");
            if (targetDirectory != null && targetDirectory.isDirectory() && !FileUtils.deleteTree((File)targetDirectory)) {
                Assert.fail((String)"Unable to delete test directory");
            }
        }
    }

    @Test
    public void testGetResourceURL_fromDirectory_resourceFileDoesNotExist() throws IOException {
        File targetDirectory = null;
        try {
            targetDirectory = this.createTestDirectory();
            System.setProperty("org.esa.smos.dddbDir", targetDirectory.getAbsolutePath());
            URL resourceUrl = this.resourceHandler.getResourceUrl("wurst");
            Assert.assertNull((Object)resourceUrl);
        }
        finally {
            System.clearProperty("org.esa.smos.dddbDir");
            if (targetDirectory != null && targetDirectory.isDirectory() && !FileUtils.deleteTree((File)targetDirectory)) {
                Assert.fail((String)"Unable to delete test directory");
            }
        }
    }

    @Test
    public void testGetResourceAsProperties_fromJar() throws IOException {
        Properties properties = this.resourceHandler.getResourceAsProperties("structs_MIR_SCXX1C.properties");
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((Object)"true", (Object)properties.getProperty("Quality_Information_Type"));
    }

    @Test
    public void testGetResourceAsProperties_fromJar_unknownProperty() throws IOException {
        Properties properties = this.resourceHandler.getResourceAsProperties("stupid_and_invalid.properties");
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((long)0L, (long)properties.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResourceAsProperties_fromDirectory() throws IOException {
        File targetDirectory = null;
        try {
            targetDirectory = this.createTestDirectory();
            System.setProperty("org.esa.smos.dddbDir", targetDirectory.getAbsolutePath());
            File testFile = this.createTestFile(targetDirectory, "test.properties");
            PrintWriter writer = new PrintWriter(testFile);
            writer.println("the_property = a_value");
            writer.close();
            Properties properties = this.resourceHandler.getResourceAsProperties("test.properties");
            Assert.assertNotNull((Object)properties);
            Assert.assertEquals((Object)"a_value", (Object)properties.getProperty("the_property"));
        }
        finally {
            System.clearProperty("org.esa.smos.dddbDir");
            if (targetDirectory != null && targetDirectory.isDirectory() && !FileUtils.deleteTree((File)targetDirectory)) {
                Assert.fail((String)"Unable to delete test directory");
            }
        }
    }

    private File createTestFile(File targetDirectory, String testFileName) throws IOException {
        File testFile = new File(targetDirectory, testFileName);
        if (!testFile.createNewFile()) {
            Assert.fail((String)"unable to create test file.");
        }
        return testFile;
    }

    private File createTestDirectory() {
        File targetDirectory = new File("test_out");
        if (!targetDirectory.mkdirs()) {
            Assert.fail((String)"unable to create test directory.");
        }
        return targetDirectory;
    }
}

