/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import org.esa.smos.dataio.smos.dddb.MemberDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemberDescriptorTest {
    private MemberDescriptor descriptor;

    @Before
    public void setUp() {
        this.descriptor = new MemberDescriptor();
    }

    @Test
    public void testSetIsGridPointData() {
        this.descriptor.setGridPointData(true);
        Assert.assertTrue((boolean)this.descriptor.isGridPointData());
        this.descriptor.setGridPointData(false);
        Assert.assertFalse((boolean)this.descriptor.isGridPointData());
    }

    @Test
    public void testSetGetDataTypeName() {
        String name_1 = "data";
        String name_2 = "type";
        this.descriptor.setDataTypeName("data");
        Assert.assertEquals((Object)"data", (Object)this.descriptor.getDataTypeName());
        this.descriptor.setDataTypeName("type");
        Assert.assertEquals((Object)"type", (Object)this.descriptor.getDataTypeName());
    }

    @Test
    public void testSetGetBinXName() {
        String binXName_1 = "binary";
        String binXName_2 = "xName";
        this.descriptor.setBinXName("binary");
        Assert.assertEquals((Object)"binary", (Object)this.descriptor.getBinXName());
        this.descriptor.setBinXName("xName");
        Assert.assertEquals((Object)"xName", (Object)this.descriptor.getBinXName());
    }

    @Test
    public void testSetGetDimensionNames() {
        String name_1 = "dimension";
        String name_2 = "name";
        this.descriptor.setDimensionNames("dimension");
        Assert.assertEquals((Object)"dimension", (Object)this.descriptor.getDimensionNames());
        this.descriptor.setDimensionNames("name");
        Assert.assertEquals((Object)"name", (Object)this.descriptor.getDimensionNames());
    }

    @Test
    public void testSetGetMemberIndex() {
        this.descriptor.setMemberIndex(3);
        Assert.assertEquals((long)3L, (long)this.descriptor.getMemberIndex());
        this.descriptor.setMemberIndex(-1);
        Assert.assertEquals((long)-1L, (long)this.descriptor.getMemberIndex());
    }

    @Test
    public void testSetGetCompoundIndex() {
        this.descriptor.setCompoundIndex(3);
        Assert.assertEquals((long)3L, (long)this.descriptor.getCompoundIndex());
        this.descriptor.setCompoundIndex(-6);
        Assert.assertEquals((long)-6L, (long)this.descriptor.getCompoundIndex());
    }

    @Test
    public void testSetGetFlagMasks() {
        short[] masks = new short[]{2, 4, 6};
        this.descriptor.setFlagMasks(masks);
        short[] masksRead = this.descriptor.getFlagMasks();
        Assert.assertArrayEquals((short[])masks, (short[])masksRead);
    }

    @Test
    public void testSetGetFlagValues() {
        short[] values = new short[]{3, 6, 9};
        this.descriptor.setFlagValues(values);
        short[] valuesRead = this.descriptor.getFlagValues();
        Assert.assertArrayEquals((short[])values, (short[])valuesRead);
    }

    @Test
    public void testSetGetFlagMeanings() {
        String meaning_1 = "I mean";
        String meaning_2 = "it seriously";
        this.descriptor.setFlagMeanings("I mean");
        Assert.assertEquals((Object)"I mean", (Object)this.descriptor.getFlagMeanings());
        this.descriptor.setFlagMeanings("it seriously");
        Assert.assertEquals((Object)"it seriously", (Object)this.descriptor.getFlagMeanings());
    }

    @Test
    public void testSetGetUnit() {
        String unit_1 = "square heads";
        String unit_2 = "milligrams";
        this.descriptor.setUnit("square heads");
        Assert.assertEquals((Object)"square heads", (Object)this.descriptor.getUnit());
        this.descriptor.setUnit("milligrams");
        Assert.assertEquals((Object)"milligrams", (Object)this.descriptor.getUnit());
    }

    @Test
    public void testSetGetFillValue() {
        float fill_1 = 3.6f;
        float fill_2 = -9.4f;
        this.descriptor.setFillValue(3.6f);
        Assert.assertEquals((double)3.6f, (double)this.descriptor.getFillValue(), (double)1.0E-8);
        this.descriptor.setFillValue(-9.4f);
        Assert.assertEquals((double)-9.4f, (double)this.descriptor.getFillValue(), (double)1.0E-8);
    }

    @Test
    public void testSetGetScalingFactor() {
        float factor_1 = 0.34f;
        float factor_2 = 1.45f;
        this.descriptor.setScalingFactor(0.34f);
        Assert.assertEquals((double)0.34f, (double)this.descriptor.getScalingFactor(), (double)1.0E-8);
        this.descriptor.setScalingFactor(1.45f);
        Assert.assertEquals((double)1.45f, (double)this.descriptor.getScalingFactor(), (double)1.0E-8);
    }

    @Test
    public void testSetGetScalingOffset() {
        float offset_1 = 1.67f;
        float offset_2 = 2.18f;
        this.descriptor.setScalingOffset(1.67f);
        Assert.assertEquals((double)1.67f, (double)this.descriptor.getScalingOffset(), (double)1.0E-8);
        this.descriptor.setScalingOffset(2.18f);
        Assert.assertEquals((double)2.18f, (double)this.descriptor.getScalingOffset(), (double)1.0E-8);
    }
}

