/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.FlagDescriptors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FlagDescriptorsTest {
    private FlagDescriptors flagDescriptors;
    private ArrayList<String[]> recordList;

    @Before
    public void setUp() {
        String[] tokens_1 = new String[]{"true", "flagName_1", "1000", "2000", "0.78", "description_1"};
        String[] tokens_2 = new String[]{"false", "flagName_2", "3000", "4000", "0.88", "description_2"};
        this.recordList = new ArrayList();
        this.recordList.add(tokens_1);
        this.recordList.add(tokens_2);
        this.flagDescriptors = new FlagDescriptors(this.recordList);
    }

    @Test
    public void testAsList() {
        List descriptorList = this.flagDescriptors.asList();
        Assert.assertNotNull((Object)descriptorList);
        Assert.assertThat((Object)descriptorList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Collections.unmodifiableList(this.recordList).getClass())));
        Assert.assertEquals((long)2L, (long)descriptorList.size());
        Assert.assertEquals((Object)"description_2", (Object)((FlagDescriptor)descriptorList.get(1)).getDescription());
    }

    @Test
    public void testGetMember() {
        FlagDescriptor member = this.flagDescriptors.getMember("flagName_1");
        Assert.assertNotNull((Object)member);
        Assert.assertEquals((long)4096L, (long)member.getMask());
    }

    @Test
    public void testInterfaceImplemented() {
        Assert.assertThat((Object)this.flagDescriptors, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Family.class)));
    }
}

