/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import org.esa.smos.dataio.smos.dddb.FlagDescriptorImpl;
import org.junit.Assert;
import org.junit.Test;

public class FlagDescriptorImplTest {
    @Test
    public void testConstructFromTokens() {
        String[] tokens = new String[]{"true", "flagName", "1000", "2000", "0.78", "description"};
        FlagDescriptorImpl flagDescriptor = new FlagDescriptorImpl(tokens);
        Assert.assertTrue((boolean)flagDescriptor.isVisible());
        Assert.assertEquals((Object)"flagName", (Object)flagDescriptor.getFlagName());
        Assert.assertEquals((long)4096L, (long)flagDescriptor.getMask());
        Assert.assertEquals((Object)"java.awt.Color[r=0,g=32,b=0]", (Object)flagDescriptor.getColor().toString());
        Assert.assertEquals((double)0.78, (double)flagDescriptor.getTransparency(), (double)1.0E-8);
        Assert.assertEquals((Object)"description", (Object)flagDescriptor.getDescription());
    }

    @Test
    public void testConstructFromTokens_useDefaultValues() {
        String[] tokens = new String[]{"*", "Merkel", "*", "*", "*", "*"};
        FlagDescriptorImpl flagDescriptor = new FlagDescriptorImpl(tokens);
        Assert.assertFalse((boolean)flagDescriptor.isVisible());
        Assert.assertEquals((Object)"Merkel", (Object)flagDescriptor.getFlagName());
        Assert.assertEquals((long)0L, (long)flagDescriptor.getMask());
        Assert.assertNull((Object)flagDescriptor.getColor());
        Assert.assertEquals((double)0.5, (double)flagDescriptor.getTransparency(), (double)1.0E-8);
        Assert.assertEquals((Object)"", (Object)flagDescriptor.getDescription());
    }
}

