/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.MemberDescriptor;
import org.esa.smos.dataio.smos.dddb.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DddbTest {
    private static final String DBL_SM_XXXX_AUX_ECMWF__0200 = "DBL_SM_XXXX_AUX_ECMWF__0200";
    private static final String DBL_SM_XXXX_MIR_SMDAP2_0200 = "DBL_SM_XXXX_MIR_SMDAP2_0200";
    private static final String DBL_SM_XXXX_MIR_SMDAP2_0201 = "DBL_SM_XXXX_MIR_SMDAP2_0201";
    private static final String DBL_SM_XXXX_MIR_SMDAP2_0300 = "DBL_SM_XXXX_MIR_SMDAP2_0300";
    private static final String DBL_SM_XXXX_MIR_OSDAP2_0200 = "DBL_SM_XXXX_MIR_OSDAP2_0200";
    private static final String DBL_SM_XXXX_MIR_OSDAP2_0300 = "DBL_SM_XXXX_MIR_OSDAP2_0300";
    private static final String DBL_SM_XXXX_MIR_OSUDP2_0200 = "DBL_SM_XXXX_MIR_OSUDP2_0200";
    private static final String DBL_SM_XXXX_MIR_OSUDP2_0300 = "DBL_SM_XXXX_MIR_OSUDP2_0300";
    private static final String DBL_SM_XXXX_MIR_SMUDP2_0200 = "DBL_SM_XXXX_MIR_SMUDP2_0200";
    private static final String DBL_SM_XXXX_AUX_DGGROU_0400 = "DBL_SM_XXXX_AUX_DGGROU_0400";
    private static final String DBL_SM_XXXX_AUX_DGGTFO_0300 = "DBL_SM_XXXX_AUX_DGGTFO_0300";
    private static final String DBL_SM_XXXX_MIR_BWLF1C_0200 = "DBL_SM_XXXX_MIR_BWLF1C_0200";
    private static final String DBL_SM_XXXX_MIR_BWND1C_0200 = "DBL_SM_XXXX_MIR_BWND1C_0200";
    private static final String DBL_SM_XXXX_MIR_BWNF1C_0200 = "DBL_SM_XXXX_MIR_BWNF1C_0200";
    private static final String DBL_SM_XXXX_AUX_DGGTLV_0300 = "DBL_SM_XXXX_AUX_DGGTLV_0300";
    private static final String DBL_SM_XXXX_MIR_BWLD1C_0400 = "DBL_SM_XXXX_MIR_BWLD1C_0400";
    private static final String DBL_SM_XXXX_MIR_BWSD1C_0200 = "DBL_SM_XXXX_MIR_BWND1C_0200";
    private Dddb dddb;

    @Before
    public void setUp() {
        this.dddb = Dddb.getInstance();
    }

    @Test
    public void testGetBandDescriptors_ECMWF() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_AUX_ECMWF__0200);
        Assert.assertEquals((long)57L, (long)descriptors.asList().size());
        BandDescriptor descriptor = (BandDescriptor)descriptors.getMember("RR");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"RR", (Object)descriptor.getBandName());
        Assert.assertEquals((Object)"Rain_Rate", (Object)descriptor.getMemberName());
        Assert.assertTrue((boolean)descriptor.hasTypicalMin());
        Assert.assertTrue((boolean)descriptor.hasTypicalMax());
        Assert.assertFalse((boolean)descriptor.isCyclic());
        Assert.assertTrue((boolean)descriptor.hasFillValue());
        Assert.assertFalse((boolean)descriptor.getValidPixelExpression().isEmpty());
        Assert.assertEquals((Object)"RR.raw != -99999.0 && RR.raw != -99998.0", (Object)descriptor.getValidPixelExpression());
        Assert.assertFalse((boolean)descriptor.getUnit().isEmpty());
        Assert.assertFalse((boolean)descriptor.getDescription().isEmpty());
        Assert.assertEquals((double)0.0, (double)descriptor.getTypicalMin(), (double)0.0);
        Assert.assertEquals((Object)"m 3h-1", (Object)descriptor.getUnit());
    }

    @Test
    public void testGetBandDescriptors_BUFR() throws Exception {
        Family descriptors = this.dddb.getBandDescriptors("BUFR");
        Assert.assertEquals((long)27L, (long)descriptors.asList().size());
        BandDescriptor flagsBandDescriptor = (BandDescriptor)descriptors.getMember("Flags");
        Assert.assertNotNull((Object)flagsBandDescriptor);
        Assert.assertEquals((Object)"Flags", (Object)flagsBandDescriptor.getFlagCodingName());
        Assert.assertNotNull((String)"Flags", (Object)flagsBandDescriptor.getFlagDescriptors());
    }

    @Test
    public void testGetFlagDescriptors_BUFR() throws Exception {
        Family descriptors = this.dddb.getFlagDescriptors("BUFR_flags");
        Assert.assertEquals((long)14L, (long)descriptors.asList().size());
    }

    @Test
    public void testGetFlagDescriptors() {
        Family descriptors = this.dddb.getFlagDescriptors("DBL_SM_XXXX_AUX_ECMWF__0200_flags1");
        Assert.assertEquals((long)21L, (long)descriptors.asList().size());
        FlagDescriptor descriptor = (FlagDescriptor)descriptors.getMember("RR_FLAG");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"RR_FLAG", (Object)descriptor.getFlagName());
        Assert.assertEquals((long)128L, (long)descriptor.getMask());
        Assert.assertNull((Object)descriptor.getColor());
        Assert.assertEquals((double)0.5, (double)descriptor.getTransparency(), (double)0.0);
        Assert.assertFalse((boolean)descriptor.getDescription().isEmpty());
    }

    @Test
    public void testGetFlagDescriptorsFromBandDescriptor() {
        Family bandDescriptor = this.dddb.getBandDescriptors(DBL_SM_XXXX_AUX_ECMWF__0200);
        Family flagDescriptors = ((BandDescriptor)bandDescriptor.getMember("F1")).getFlagDescriptors();
        Assert.assertNotNull((Object)flagDescriptors);
        Assert.assertNotNull((Object)this.dddb.getFlagDescriptors("DBL_SM_XXXX_AUX_ECMWF__0200_flags1"));
        Assert.assertSame((Object)flagDescriptors, (Object)this.dddb.getFlagDescriptors("DBL_SM_XXXX_AUX_ECMWF__0200_flags1"));
    }

    @Test
    public void testFindBandDescriptorForMember() {
        BandDescriptor descriptor = this.dddb.findBandDescriptorForMember(DBL_SM_XXXX_MIR_OSUDP2_0300, "Sigma_Tb_42.5Y");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Sigma_TBY", (Object)descriptor.getBandName());
    }

    @Test
    public void testFindBandDescriptorForMember_unknownFormatName() {
        Assert.assertNull((Object)this.dddb.findBandDescriptorForMember("schnick-schnack-for-mat", "Sigma_Tb_42.5Y"));
    }

    @Test
    public void testFindBandDescriptorForMember_unknownBandName() {
        Assert.assertNull((Object)this.dddb.findBandDescriptorForMember(DBL_SM_XXXX_MIR_OSUDP2_0300, "rubber-band"));
    }

    @Test
    public void testGetSMDAP2_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_SMDAP2_0200);
        Assert.assertEquals((long)70L, (long)descriptors.asList().size());
        BandDescriptor x_swath = (BandDescriptor)descriptors.getMember("X_Swath");
        Assert.assertNotNull((Object)x_swath);
    }

    @Test
    public void testGetSMDAP2_v0201Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_SMDAP2_0201);
        Assert.assertEquals((long)70L, (long)descriptors.asList().size());
        BandDescriptor tSurf_init_std = (BandDescriptor)descriptors.getMember("TSurf_Init_Std");
        Assert.assertNotNull((Object)tSurf_init_std);
    }

    @Test
    public void testGetSMDAP2_v0300Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_SMDAP2_0300);
        Assert.assertEquals((long)70L, (long)descriptors.asList().size());
        BandDescriptor hr_in_dqx = (BandDescriptor)descriptors.getMember("HR_IN_DQX");
        Assert.assertNotNull((Object)hr_in_dqx);
    }

    @Test
    public void testGetOSDAP2_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_OSDAP2_0200);
        Assert.assertEquals((long)133L, (long)descriptors.asList().size());
        BandDescriptor param2_sigma_m3 = (BandDescriptor)descriptors.getMember("Param2_sigma_M3");
        Assert.assertNotNull((Object)param2_sigma_m3);
        BandDescriptor param6_sigma_m2 = (BandDescriptor)descriptors.getMember("Param6_sigma_M2");
        Assert.assertNotNull((Object)param6_sigma_m2);
    }

    @Test
    public void testGetOSDAP2_v0300Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_OSDAP2_0300);
        Assert.assertEquals((long)133L, (long)descriptors.asList().size());
        BandDescriptor out_of_lut_flags_4 = (BandDescriptor)descriptors.getMember("Out_of_LUT_flags_4");
        Assert.assertNotNull((Object)out_of_lut_flags_4);
        BandDescriptor diff_tb_1 = (BandDescriptor)descriptors.getMember("Diff_TB_1");
        Assert.assertNotNull((Object)diff_tb_1);
    }

    @Test
    public void testGetOSUDP2_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_OSUDP2_0200);
        Assert.assertEquals((long)64L, (long)descriptors.asList().size());
        BandDescriptor dg_num_meas_l1c = (BandDescriptor)descriptors.getMember("Dg_num_meas_L1c");
        Assert.assertNotNull((Object)dg_num_meas_l1c);
        BandDescriptor a_card = (BandDescriptor)descriptors.getMember("Acard");
        Assert.assertNotNull((Object)a_card);
    }

    @Test
    public void testGetSMUPD2_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_SMUDP2_0200);
        Assert.assertEquals((long)66L, (long)descriptors.asList().size());
        BandDescriptor n_instrument_error = (BandDescriptor)descriptors.getMember("N_Instrument_Error");
        Assert.assertNotNull((Object)n_instrument_error);
    }

    @Test
    public void testGetMemberDescriptors_BWLF1C() throws IOException {
        File hdrFile = TestHelper.getResourceFile("SM_OPER_MIR_BWLF1C_20111026T143206_20111026T152520_503_001_1.HDR");
        Family memberDescriptors = this.dddb.getMemberDescriptors(hdrFile);
        Assert.assertNotNull((Object)memberDescriptors);
        Assert.assertEquals((long)12L, (long)memberDescriptors.asList().size());
        MemberDescriptor flagsDescriptor = (MemberDescriptor)memberDescriptors.getMember("Flags");
        Assert.assertNotNull((Object)flagsDescriptor);
        Assert.assertTrue((boolean)flagsDescriptor.isGridPointData());
        Assert.assertEquals((Object)"ushort", (Object)flagsDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points n_bt_data", (Object)flagsDescriptor.getDimensionNames());
        Assert.assertEquals((long)0L, (long)flagsDescriptor.getMemberIndex());
        short[] flagMasks = flagsDescriptor.getFlagMasks();
        Assert.assertNotNull((Object)flagMasks);
        Assert.assertEquals((long)16L, (long)flagMasks.length);
        short[] flagValues = flagsDescriptor.getFlagValues();
        Assert.assertNotNull((Object)flagValues);
        Assert.assertEquals((long)16L, (long)flagValues.length);
        Assert.assertEquals((Object)"POL_FLAG_1 POL_FLAG_2 SUN_FOV SUN_GLINT_FOV MOON_GLINT_FOV SINGLE_SNAPSHOT FTT SUN_POINT SUN_GLINT_AREA MOON_POINT AF_FOV EAF_FOV BORDER_FOV SUN_TAILS RFI_1 RFI_2", (Object)flagsDescriptor.getFlagMeanings());
        Assert.assertEquals((Object)"", (Object)flagsDescriptor.getUnit());
        Assert.assertEquals((double)0.0, (double)flagsDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)flagsDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)flagsDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor btValueDescriptor = (MemberDescriptor)memberDescriptors.getMember("BT_Value");
        Assert.assertNotNull((Object)btValueDescriptor);
        Assert.assertTrue((boolean)btValueDescriptor.isGridPointData());
        Assert.assertEquals((Object)"float", (Object)btValueDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points n_bt_data", (Object)btValueDescriptor.getDimensionNames());
        Assert.assertEquals((long)1L, (long)btValueDescriptor.getMemberIndex());
        Assert.assertNull((Object)btValueDescriptor.getFlagMasks());
        Assert.assertEquals((Object)"K", (Object)btValueDescriptor.getUnit());
        Assert.assertEquals((double)-999.0, (double)btValueDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)btValueDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)btValueDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor radiometricAccuracyOfPixelDescriptor = (MemberDescriptor)memberDescriptors.getMember("Radiometric_Accuracy_of_Pixel");
        Assert.assertNotNull((Object)radiometricAccuracyOfPixelDescriptor);
        Assert.assertTrue((boolean)radiometricAccuracyOfPixelDescriptor.isGridPointData());
        Assert.assertEquals((Object)"ushort", (Object)radiometricAccuracyOfPixelDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points n_bt_data", (Object)radiometricAccuracyOfPixelDescriptor.getDimensionNames());
        Assert.assertEquals((long)2L, (long)radiometricAccuracyOfPixelDescriptor.getMemberIndex());
        Assert.assertNull((Object)radiometricAccuracyOfPixelDescriptor.getFlagValues());
        Assert.assertEquals((Object)"K", (Object)radiometricAccuracyOfPixelDescriptor.getUnit());
        Assert.assertEquals((double)0.0, (double)radiometricAccuracyOfPixelDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.52587890625E-5, (double)radiometricAccuracyOfPixelDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)radiometricAccuracyOfPixelDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor azimuthAngleDescriptor = (MemberDescriptor)memberDescriptors.getMember("Azimuth_Angle");
        Assert.assertNotNull((Object)azimuthAngleDescriptor);
        Assert.assertTrue((boolean)azimuthAngleDescriptor.isGridPointData());
        Assert.assertEquals((Object)"ushort", (Object)azimuthAngleDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points n_bt_data", (Object)azimuthAngleDescriptor.getDimensionNames());
        Assert.assertEquals((long)3L, (long)azimuthAngleDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"deg", (Object)azimuthAngleDescriptor.getUnit());
        Assert.assertEquals((double)0.0, (double)azimuthAngleDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)0.0054931640625, (double)azimuthAngleDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)azimuthAngleDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor footprintAxis1Descriptor = (MemberDescriptor)memberDescriptors.getMember("Footprint_Axis1");
        Assert.assertNotNull((Object)footprintAxis1Descriptor);
        Assert.assertTrue((boolean)footprintAxis1Descriptor.isGridPointData());
        Assert.assertEquals((Object)"ushort", (Object)footprintAxis1Descriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points n_bt_data", (Object)footprintAxis1Descriptor.getDimensionNames());
        Assert.assertEquals((long)4L, (long)footprintAxis1Descriptor.getMemberIndex());
        Assert.assertEquals((Object)"km", (Object)footprintAxis1Descriptor.getUnit());
        Assert.assertEquals((double)0.0, (double)footprintAxis1Descriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.52587890625E-5, (double)footprintAxis1Descriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)footprintAxis1Descriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor footprintAxis2Descriptor = (MemberDescriptor)memberDescriptors.getMember("Footprint_Axis2");
        Assert.assertNotNull((Object)footprintAxis2Descriptor);
        Assert.assertTrue((boolean)footprintAxis2Descriptor.isGridPointData());
        Assert.assertEquals((Object)"ushort", (Object)footprintAxis2Descriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points n_bt_data", (Object)footprintAxis2Descriptor.getDimensionNames());
        Assert.assertEquals((long)5L, (long)footprintAxis2Descriptor.getMemberIndex());
        Assert.assertEquals((Object)"km", (Object)footprintAxis2Descriptor.getUnit());
        Assert.assertEquals((double)0.0, (double)footprintAxis2Descriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.52587890625E-5, (double)footprintAxis2Descriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)footprintAxis2Descriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor gridPointIdDescriptor = (MemberDescriptor)memberDescriptors.getMember("Grid_Point_ID");
        Assert.assertNotNull((Object)gridPointIdDescriptor);
        Assert.assertTrue((boolean)gridPointIdDescriptor.isGridPointData());
        Assert.assertEquals((Object)"uint", (Object)gridPointIdDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points", (Object)gridPointIdDescriptor.getDimensionNames());
        Assert.assertEquals((long)0L, (long)gridPointIdDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"", (Object)gridPointIdDescriptor.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)gridPointIdDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)gridPointIdDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)gridPointIdDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor latitudeDescriptor = (MemberDescriptor)memberDescriptors.getMember("Grid_Point_Latitude");
        Assert.assertNotNull((Object)latitudeDescriptor);
        Assert.assertEquals((Object)"Latitude", (Object)latitudeDescriptor.getBinXName());
        Assert.assertTrue((boolean)latitudeDescriptor.isGridPointData());
        Assert.assertEquals((Object)"float", (Object)latitudeDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points", (Object)latitudeDescriptor.getDimensionNames());
        Assert.assertEquals((long)1L, (long)latitudeDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"deg", (Object)latitudeDescriptor.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)latitudeDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)latitudeDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)latitudeDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor longitudeDescriptor = (MemberDescriptor)memberDescriptors.getMember("Grid_Point_Longitude");
        Assert.assertNotNull((Object)longitudeDescriptor);
        Assert.assertEquals((Object)"Longitude", (Object)longitudeDescriptor.getBinXName());
        Assert.assertTrue((boolean)longitudeDescriptor.isGridPointData());
        Assert.assertEquals((Object)"float", (Object)longitudeDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points", (Object)longitudeDescriptor.getDimensionNames());
        Assert.assertEquals((long)2L, (long)longitudeDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"deg", (Object)longitudeDescriptor.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)longitudeDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)longitudeDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)longitudeDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor altitudeDescriptor = (MemberDescriptor)memberDescriptors.getMember("Grid_Point_Altitude");
        Assert.assertNotNull((Object)altitudeDescriptor);
        Assert.assertEquals((Object)"Altitude", (Object)altitudeDescriptor.getBinXName());
        Assert.assertTrue((boolean)altitudeDescriptor.isGridPointData());
        Assert.assertEquals((Object)"float", (Object)altitudeDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points", (Object)altitudeDescriptor.getDimensionNames());
        Assert.assertEquals((long)3L, (long)altitudeDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"m", (Object)altitudeDescriptor.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)altitudeDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)altitudeDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)altitudeDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor maskDescriptor = (MemberDescriptor)memberDescriptors.getMember("Grid_Point_Mask");
        Assert.assertNotNull((Object)maskDescriptor);
        Assert.assertTrue((boolean)maskDescriptor.isGridPointData());
        Assert.assertEquals((Object)"ubyte", (Object)maskDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points", (Object)maskDescriptor.getDimensionNames());
        Assert.assertEquals((long)4L, (long)maskDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"", (Object)maskDescriptor.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)maskDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)maskDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)maskDescriptor.getScalingOffset(), (double)1.0E-8);
        MemberDescriptor btCountDescriptor = (MemberDescriptor)memberDescriptors.getMember("BT_Data_Counter");
        Assert.assertNotNull((Object)btCountDescriptor);
        Assert.assertTrue((boolean)btCountDescriptor.isGridPointData());
        Assert.assertEquals((Object)"ubyte", (Object)btCountDescriptor.getDataTypeName());
        Assert.assertEquals((Object)"n_grid_points", (Object)btCountDescriptor.getDimensionNames());
        Assert.assertEquals((long)5L, (long)btCountDescriptor.getMemberIndex());
        Assert.assertEquals((Object)"", (Object)btCountDescriptor.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)btCountDescriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)btCountDescriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)btCountDescriptor.getScalingOffset(), (double)1.0E-8);
    }

    @Test
    public void testGetDGGROU_v0400Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_AUX_DGGROU_0400);
        Assert.assertEquals((long)11L, (long)descriptors.asList().size());
        BandDescriptor dt_branch_hr_asc = (BandDescriptor)descriptors.getMember("DT_Branch_HR_Asc");
        Assert.assertNotNull((Object)dt_branch_hr_asc);
        Assert.assertEquals((Object)"DT_Branch_HR_Asc", (Object)dt_branch_hr_asc.getMemberName());
        BandDescriptor hr_asc = (BandDescriptor)descriptors.getMember("HR_Asc");
        Assert.assertNotNull((Object)hr_asc);
        Assert.assertEquals((Object)"HR_DQX_Asc", (Object)hr_asc.getAncilliaryBandName());
        Assert.assertEquals((long)-1L, (long)hr_asc.getPolarization());
    }

    @Test
    public void testGetDGGTFO_v0300Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_AUX_DGGTFO_0300);
        Assert.assertEquals((long)7L, (long)descriptors.asList().size());
        BandDescriptor date_stamp_fo = (BandDescriptor)descriptors.getMember("Date_Stamp_FO");
        Assert.assertNotNull((Object)date_stamp_fo);
        Assert.assertEquals((long)0L, (long)date_stamp_fo.getSampleModel());
        BandDescriptor tau_nad_fo = (BandDescriptor)descriptors.getMember("Tau_Nad_FO");
        Assert.assertNotNull((Object)tau_nad_fo);
        Assert.assertEquals((Object)"Tau_Nad_FO_DQX", (Object)tau_nad_fo.getAncilliaryBandName());
        Assert.assertEquals((double)0.0, (double)tau_nad_fo.getScalingOffset(), (double)1.0E-8);
    }

    @Test
    public void testGetBWLF1C_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_BWLF1C_0200);
        Assert.assertEquals((long)25L, (long)descriptors.asList().size());
        BandDescriptor footprint_axis2_xy = (BandDescriptor)descriptors.getMember("Footprint_Axis2_XY");
        Assert.assertNotNull((Object)footprint_axis2_xy);
        BandDescriptor bt_value_xy_real = (BandDescriptor)descriptors.getMember("BT_Value_XY_Real");
        Assert.assertNotNull((Object)bt_value_xy_real);
        Assert.assertEquals((Object)"Pixel_Radiometric_Accuracy_XY", (Object)bt_value_xy_real.getAncilliaryBandName());
    }

    @Test
    public void testGetBWND1C_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors("DBL_SM_XXXX_MIR_BWND1C_0200");
        Assert.assertEquals((long)18L, (long)descriptors.asList().size());
        BandDescriptor flags_x = (BandDescriptor)descriptors.getMember("Flags_X");
        Assert.assertNotNull((Object)flags_x);
        Assert.assertEquals((double)1.0, (double)flags_x.getScalingFactor(), (double)1.0E-8);
        BandDescriptor bt_value_y = (BandDescriptor)descriptors.getMember("BT_Value_Y");
        Assert.assertNotNull((Object)bt_value_y);
        Assert.assertEquals((Object)"Pixel_Radiometric_Accuracy_Y", (Object)bt_value_y.getAncilliaryBandName());
        Assert.assertEquals((double)0.0, (double)bt_value_y.getTypicalMin(), (double)1.0E-8);
    }

    @Test
    public void testGetBWNF1C_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_BWNF1C_0200);
        Assert.assertEquals((long)25L, (long)descriptors.asList().size());
        BandDescriptor flags_xy = (BandDescriptor)descriptors.getMember("Flags_XY");
        Assert.assertNotNull((Object)flags_xy);
        BandDescriptor bt_value_xy_real = (BandDescriptor)descriptors.getMember("BT_Value_XY_Real");
        Assert.assertNotNull((Object)bt_value_xy_real);
        Assert.assertEquals((Object)"Pixel_Radiometric_Accuracy_XY", (Object)bt_value_xy_real.getAncilliaryBandName());
    }

    @Test
    public void testGetDGGTLV_v0300Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_AUX_DGGTLV_0300);
        Assert.assertEquals((long)7L, (long)descriptors.asList().size());
        BandDescriptor dt_branch_lv = (BandDescriptor)descriptors.getMember("DT_Branch_LV");
        Assert.assertNotNull((Object)dt_branch_lv);
        BandDescriptor tau_nad_lv = (BandDescriptor)descriptors.getMember("Tau_Nad_LV");
        Assert.assertNotNull((Object)tau_nad_lv);
        Assert.assertEquals((Object)"Tau_Nad_LV_DQX", (Object)tau_nad_lv.getAncilliaryBandName());
    }

    @Test
    public void testGetBWLD1C_v0400Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors(DBL_SM_XXXX_MIR_BWLD1C_0400);
        Assert.assertEquals((long)18L, (long)descriptors.asList().size());
        BandDescriptor footprint_axis2_y = (BandDescriptor)descriptors.getMember("Footprint_Axis2_Y");
        Assert.assertNotNull((Object)footprint_axis2_y);
        BandDescriptor bt_value_y = (BandDescriptor)descriptors.getMember("BT_Value_Y");
        Assert.assertNotNull((Object)bt_value_y);
        Assert.assertEquals((Object)"Pixel_Radiometric_Accuracy_Y", (Object)bt_value_y.getAncilliaryBandName());
    }

    @Test
    public void testGetBWSD1C_v0200Descriptors() {
        Family descriptors = this.dddb.getBandDescriptors("DBL_SM_XXXX_MIR_BWND1C_0200");
        Assert.assertEquals((long)18L, (long)descriptors.asList().size());
        BandDescriptor flags_x = (BandDescriptor)descriptors.getMember("Flags_X");
        Assert.assertNotNull((Object)flags_x);
        BandDescriptor bt_value_x = (BandDescriptor)descriptors.getMember("BT_Value_X");
        Assert.assertNotNull((Object)bt_value_x);
        Assert.assertEquals((Object)"Pixel_Radiometric_Accuracy_X", (Object)bt_value_x.getAncilliaryBandName());
    }

    @Test
    public void testGetOriginalName() {
        Properties properties = new Properties();
        properties.setProperty("a_key", "a_value");
        properties.setProperty("another_key", "another_value");
        String key = Dddb.findOriginalName((Properties)properties, (String)"another_value");
        Assert.assertEquals((Object)"another_key", (Object)key);
    }

    @Test
    public void testGetOriginalName_nameNotInProperties() {
        Properties properties = new Properties();
        properties.setProperty("a_key", "a_value");
        properties.setProperty("another_key", "another_value");
        String key = Dddb.findOriginalName((Properties)properties, (String)"the Werner Value");
        Assert.assertNull((Object)key);
    }

    @Test
    public void testExtractUniqueMemberNames() {
        ArrayList<TestBandDescriptor> descriptors = new ArrayList<TestBandDescriptor>();
        descriptors.add(new TestBandDescriptor("name"));
        descriptors.add(new TestBandDescriptor("name_2"));
        descriptors.add(new TestBandDescriptor("name_3"));
        descriptors.add(new TestBandDescriptor("name_4"));
        descriptors.add(new TestBandDescriptor("name_2"));
        descriptors.add(new TestBandDescriptor("name"));
        Map descriptorMap = Dddb.extractUniqueMembers(descriptors);
        Assert.assertEquals((long)4L, (long)descriptorMap.size());
        Assert.assertTrue((boolean)descriptorMap.containsKey("name"));
        Assert.assertTrue((boolean)descriptorMap.containsKey("name_2"));
        Assert.assertTrue((boolean)descriptorMap.containsKey("name_3"));
        Assert.assertTrue((boolean)descriptorMap.containsKey("name_4"));
    }

    @Test
    public void testGetEEVariableName() throws IOException {
        Assert.assertEquals((Object)"Footprint_Axis2", (Object)this.dddb.getEEVariableName("Footprint_Axis2", "DBL_SM_XXXX_MIR_BWND1C_0200"));
        Assert.assertEquals((Object)"Radiometric_Accuracy_of_Pixel", (Object)this.dddb.getEEVariableName("Pixel_Radiometric_Accuracy", "DBL_SM_XXXX_MIR_BWND1C_0200"));
        Assert.assertEquals((Object)"schneckBand", (Object)this.dddb.getEEVariableName("schneckBand", "invalid_schema"));
    }

    private class TestBandDescriptor
    implements BandDescriptor {
        private final String memberName;

        private TestBandDescriptor(String memberName) {
            this.memberName = memberName;
        }

        public String getBandName() {
            return null;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public int getPolarization() {
            return 0;
        }

        public boolean isVisible() {
            return false;
        }

        public int getSampleModel() {
            return 0;
        }

        public double getScalingOffset() {
            return 0.0;
        }

        public double getScalingFactor() {
            return 0.0;
        }

        public boolean hasTypicalMin() {
            return false;
        }

        public boolean hasTypicalMax() {
            return false;
        }

        public boolean hasFillValue() {
            return false;
        }

        public double getTypicalMin() {
            return 0.0;
        }

        public double getTypicalMax() {
            return 0.0;
        }

        public double getFillValue() {
            return 0.0;
        }

        public String getValidPixelExpression() {
            return null;
        }

        public String getUnit() {
            return null;
        }

        public boolean isCyclic() {
            return false;
        }

        public String getDescription() {
            return null;
        }

        public String getFlagCodingName() {
            return null;
        }

        public Family<FlagDescriptor> getFlagDescriptors() {
            return null;
        }

        public String getAncilliaryBandName() {
            return null;
        }

        public boolean isGridPointData() {
            return false;
        }

        public String getDimensionNames() {
            return null;
        }
    }
}

