/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.BandDescriptors;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BandDescriptorsTest {
    private BandDescriptors bandDescriptors;
    private ArrayList<String[]> recordList;

    @Before
    public void setIUp() {
        String[] tokens_1 = new String[]{"false", "theBand_1", "theMember_1", "18", "19", "20.0", "21.1", "22.2", "23.3", "true", "24.4", "pixelExpression_1", "unit_1", "description_1", "codingName_1", "flagDescriptors_1"};
        String[] tokens_2 = new String[]{"false", "theBand_2", "theMember_2", "18", "19", "20.0", "21.1", "22.2", "23.3", "true", "24.4", "pixelExpression_2", "unit_2", "description_2", "codingName_2", "flagDescriptors_2"};
        this.recordList = new ArrayList();
        this.recordList.add(tokens_1);
        this.recordList.add(tokens_2);
        Dddb dddb = (Dddb)Mockito.mock(Dddb.class);
        this.bandDescriptors = new BandDescriptors(this.recordList, dddb);
    }

    @Test
    public void testAsList() {
        List descriptorList = this.bandDescriptors.asList();
        Assert.assertNotNull((Object)descriptorList);
        Assert.assertEquals((long)2L, (long)descriptorList.size());
        Assert.assertThat((Object)descriptorList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Collections.unmodifiableList(this.recordList).getClass())));
        Assert.assertEquals((Object)"theBand_1", (Object)((BandDescriptor)descriptorList.get(0)).getBandName());
    }

    @Test
    public void testGetMember() {
        BandDescriptor member = this.bandDescriptors.getMember("theBand_2");
        Assert.assertNotNull((Object)member);
        Assert.assertEquals((Object)"theMember_2", (Object)member.getMemberName());
    }

    @Test
    public void testInterfaceImplemented() {
        Assert.assertThat((Object)this.bandDescriptors, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Family.class)));
    }
}

