/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.util.ArrayList;
import org.esa.smos.dataio.smos.dddb.BandDescriptorImpl;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.FlagDescriptors;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class BandDescriptorImplTest {
    @Test
    public void testConstruction_standardPropertySet() {
        String[] tokens = new String[]{"false", "theBand", "theMember", "18", "19", "20.0", "21.1", "22.2", "23.3", "true", "24.4", "pixelExpression", "unit", "description", "codingName", "flagDescriptors", "ancilliaryBandName"};
        Dddb dddb = (Dddb)Mockito.mock(Dddb.class);
        Mockito.when((Object)dddb.getFlagDescriptors(Matchers.anyString())).thenReturn((Object)new FlagDescriptors(new ArrayList()));
        BandDescriptorImpl descriptor = new BandDescriptorImpl(tokens, dddb);
        Assert.assertFalse((boolean)descriptor.isVisible());
        Assert.assertEquals((Object)"theBand", (Object)descriptor.getBandName());
        Assert.assertEquals((Object)"theMember", (Object)descriptor.getMemberName());
        Assert.assertEquals((long)18L, (long)descriptor.getPolarization());
        Assert.assertEquals((long)19L, (long)descriptor.getSampleModel());
        Assert.assertEquals((double)20.0, (double)descriptor.getScalingOffset(), (double)1.0E-8);
        Assert.assertEquals((double)21.1, (double)descriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)22.2, (double)descriptor.getTypicalMin(), (double)1.0E-8);
        Assert.assertEquals((double)23.3, (double)descriptor.getTypicalMax(), (double)1.0E-8);
        Assert.assertTrue((boolean)descriptor.isCyclic());
        Assert.assertEquals((double)24.4, (double)descriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((Object)"pitheBandelEtheBandpression", (Object)descriptor.getValidPixelExpression());
        Assert.assertEquals((Object)"unit", (Object)descriptor.getUnit());
        Assert.assertEquals((Object)"description", (Object)descriptor.getDescription());
        Assert.assertEquals((Object)"codingName", (Object)descriptor.getFlagCodingName());
        Assert.assertNotNull((Object)descriptor.getFlagDescriptors());
        Assert.assertEquals((Object)"ancilliaryBandName", (Object)descriptor.getAncilliaryBandName());
        Assert.assertTrue((boolean)descriptor.isGridPointData());
        Assert.assertNull((Object)descriptor.getDimensionNames());
    }

    @Test
    public void testConstruction_extendedPropertySet() {
        String[] tokens = new String[]{"false", "theBand", "theMember", "18", "19", "20.0", "21.1", "22.2", "23.3", "true", "24.4", "pixelExpression", "unit", "description", "codingName", "flagDescriptors", "ancilliaryBandName", "false", "dimension_name"};
        Dddb dddb = (Dddb)Mockito.mock(Dddb.class);
        Mockito.when((Object)dddb.getFlagDescriptors(Matchers.anyString())).thenReturn((Object)new FlagDescriptors(new ArrayList()));
        BandDescriptorImpl descriptor = new BandDescriptorImpl(tokens, dddb);
        Assert.assertFalse((boolean)descriptor.isVisible());
        Assert.assertEquals((Object)"theBand", (Object)descriptor.getBandName());
        Assert.assertEquals((Object)"theMember", (Object)descriptor.getMemberName());
        Assert.assertEquals((long)18L, (long)descriptor.getPolarization());
        Assert.assertEquals((long)19L, (long)descriptor.getSampleModel());
        Assert.assertEquals((double)20.0, (double)descriptor.getScalingOffset(), (double)1.0E-8);
        Assert.assertEquals((double)21.1, (double)descriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)22.2, (double)descriptor.getTypicalMin(), (double)1.0E-8);
        Assert.assertEquals((double)23.3, (double)descriptor.getTypicalMax(), (double)1.0E-8);
        Assert.assertTrue((boolean)descriptor.isCyclic());
        Assert.assertEquals((double)24.4, (double)descriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((Object)"pitheBandelEtheBandpression", (Object)descriptor.getValidPixelExpression());
        Assert.assertEquals((Object)"unit", (Object)descriptor.getUnit());
        Assert.assertEquals((Object)"description", (Object)descriptor.getDescription());
        Assert.assertEquals((Object)"codingName", (Object)descriptor.getFlagCodingName());
        Assert.assertNotNull((Object)descriptor.getFlagDescriptors());
        Assert.assertFalse((boolean)descriptor.isGridPointData());
        Assert.assertEquals((Object)"dimension_name", (Object)descriptor.getDimensionNames());
    }

    @Test
    public void testConstruction_withDefaults_standardPropertySet() {
        String[] tokens = new String[]{"*", "theBand", "*", "*", "*", "*", "*", "*", "*", "*", "*", "pixelExpression", "*", "*", "*", "flagDescriptors"};
        Dddb dddb = (Dddb)Mockito.mock(Dddb.class);
        BandDescriptorImpl descriptor = new BandDescriptorImpl(tokens, dddb);
        Assert.assertTrue((boolean)descriptor.isVisible());
        Assert.assertEquals((Object)"theBand", (Object)descriptor.getBandName());
        Assert.assertEquals((Object)"theBand", (Object)descriptor.getMemberName());
        Assert.assertEquals((long)-1L, (long)descriptor.getPolarization());
        Assert.assertEquals((long)0L, (long)descriptor.getSampleModel());
        Assert.assertEquals((double)0.0, (double)descriptor.getScalingOffset(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)descriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)descriptor.getTypicalMin(), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)descriptor.getTypicalMax(), (double)1.0E-8);
        Assert.assertFalse((boolean)descriptor.isCyclic());
        Assert.assertEquals((double)Double.NaN, (double)descriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((Object)"", (Object)descriptor.getUnit());
        Assert.assertEquals((Object)"", (Object)descriptor.getDescription());
        Assert.assertEquals((Object)"", (Object)descriptor.getFlagCodingName());
        Assert.assertNull((Object)descriptor.getFlagDescriptors());
        Assert.assertTrue((boolean)descriptor.isGridPointData());
        Assert.assertNull((Object)descriptor.getDimensionNames());
    }

    @Test
    public void testConstruction_withDefaults_extendedPropertySet() {
        String[] tokens = new String[]{"*", "theBand", "*", "*", "*", "*", "*", "*", "*", "*", "*", "pixelExpression", "*", "*", "*", "flagDescriptors", "*", "*", "*"};
        Dddb dddb = (Dddb)Mockito.mock(Dddb.class);
        BandDescriptorImpl descriptor = new BandDescriptorImpl(tokens, dddb);
        Assert.assertTrue((boolean)descriptor.isVisible());
        Assert.assertEquals((Object)"theBand", (Object)descriptor.getBandName());
        Assert.assertEquals((Object)"theBand", (Object)descriptor.getMemberName());
        Assert.assertEquals((long)-1L, (long)descriptor.getPolarization());
        Assert.assertEquals((long)0L, (long)descriptor.getSampleModel());
        Assert.assertEquals((double)0.0, (double)descriptor.getScalingOffset(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)descriptor.getScalingFactor(), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)descriptor.getTypicalMin(), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)descriptor.getTypicalMax(), (double)1.0E-8);
        Assert.assertFalse((boolean)descriptor.isCyclic());
        Assert.assertEquals((double)Double.NaN, (double)descriptor.getFillValue(), (double)1.0E-8);
        Assert.assertEquals((Object)"", (Object)descriptor.getUnit());
        Assert.assertEquals((Object)"", (Object)descriptor.getDescription());
        Assert.assertEquals((Object)"", (Object)descriptor.getFlagCodingName());
        Assert.assertNull((Object)descriptor.getFlagDescriptors());
        Assert.assertTrue((boolean)descriptor.isGridPointData());
        Assert.assertNull((Object)descriptor.getDimensionNames());
    }
}

