/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import org.esa.smos.dataio.smos.bufr.ValueDecoder;
import org.junit.Assert;
import org.junit.Test;

public class ValueDecoderTest {
    @Test
    public void testDecode() {
        ValueDecoder valueDecoder = new ValueDecoder(1.8, 0.65, (Number)Short.MAX_VALUE);
        Assert.assertEquals((double)0.65, (double)valueDecoder.decode(0), (double)0.0);
        Assert.assertEquals((double)2.45, (double)valueDecoder.decode(1), (double)0.0);
        Assert.assertEquals((double)-1.15, (double)valueDecoder.decode(-1), (double)0.0);
    }

    @Test
    public void testDecode_missingValue() {
        ValueDecoder valueDecoder = new ValueDecoder(1.9, 0.55, (Number)Short.MAX_VALUE);
        Assert.assertTrue((boolean)Double.isNaN(valueDecoder.decode(Short.MAX_VALUE)));
    }

    @Test
    public void testIsValid() {
        ValueDecoder valueDecoder = new ValueDecoder(2.0, 0.45, (Number)32766);
        Assert.assertTrue((boolean)valueDecoder.isValid(109));
        Assert.assertFalse((boolean)valueDecoder.isValid(32766));
    }
}

