/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import org.esa.smos.dataio.smos.bufr.ValueAccessor;
import org.esa.smos.dataio.smos.bufr.ValueAccessors;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import ucar.ma2.StructureData;

public class ValueAccessorsTest {
    @Test
    public void testGet_intAccessor() {
        ValueAccessor valueAccessor = ValueAccessors.get((String)"Azimuth_angle");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.IntValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Faraday_rotational_angle");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.IntValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Geometric_rotational_angle");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.IntValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Incidence_angle");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.IntValueAccessor));
    }

    @Test
    public void testGet_unsignedShortAccessor() {
        ValueAccessor valueAccessor = ValueAccessors.get((String)"Brightness_temperature_real_part");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.UnsignedShortValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Brightness_temperature_imaginary_part");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.UnsignedShortValueAccessor));
    }

    @Test
    public void testGet_shortAccessor() {
        ValueAccessor valueAccessor = ValueAccessors.get((String)"Footprint_axis_1");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.ShortValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Footprint_axis_2");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.ShortValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Pixel_radiometric_accuracy");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.ShortValueAccessor));
        valueAccessor = ValueAccessors.get((String)"Water_fraction");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.ShortValueAccessor));
        valueAccessor = ValueAccessors.get((String)"SMOS_information_flag");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.ShortValueAccessor));
    }

    @Test
    public void testGet_byteAccessor() {
        ValueAccessor valueAccessor = ValueAccessors.get((String)"Polarisation");
        Assert.assertTrue((boolean)(valueAccessor instanceof ValueAccessors.ByteValueAccessor));
    }

    @Test
    public void testGet_unknownDatasetName() {
        try {
            ValueAccessors.get((String)"really unknown dataset");
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRead_intValueAccessor() {
        StructureData structureData = (StructureData)Mockito.mock(StructureData.class);
        Mockito.when((Object)structureData.getScalarInt("whatever")).thenReturn((Object)19);
        Mockito.when((Object)structureData.getScalarInt("Grid_point_identifier")).thenReturn((Object)20);
        ValueAccessors.IntValueAccessor intValueAccessor = new ValueAccessors.IntValueAccessor("whatever");
        intValueAccessor.read(structureData);
        Assert.assertEquals((long)19L, (long)intValueAccessor.getRawValue());
        Assert.assertEquals((long)20L, (long)intValueAccessor.getGridPointId());
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarInt("whatever");
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarInt("Grid_point_identifier");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{structureData});
    }

    @Test
    public void testRead_unsignedShortValueAccessor() {
        StructureData structureData = (StructureData)Mockito.mock(StructureData.class);
        Mockito.when((Object)structureData.getScalarShort("member")).thenReturn((Object)21);
        Mockito.when((Object)structureData.getScalarInt("Grid_point_identifier")).thenReturn((Object)22);
        ValueAccessors.UnsignedShortValueAccessor unsignedShortValueAccessor = new ValueAccessors.UnsignedShortValueAccessor("member");
        unsignedShortValueAccessor.read(structureData);
        Assert.assertEquals((long)21L, (long)unsignedShortValueAccessor.getRawValue());
        Assert.assertEquals((long)22L, (long)unsignedShortValueAccessor.getGridPointId());
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarShort("member");
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarInt("Grid_point_identifier");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{structureData});
    }

    @Test
    public void testRead_shortValueAccessor() {
        StructureData structureData = (StructureData)Mockito.mock(StructureData.class);
        Mockito.when((Object)structureData.getScalarShort("theShort")).thenReturn((Object)23);
        Mockito.when((Object)structureData.getScalarInt("Grid_point_identifier")).thenReturn((Object)24);
        ValueAccessors.ShortValueAccessor shortValueAccessor = new ValueAccessors.ShortValueAccessor("theShort");
        shortValueAccessor.read(structureData);
        Assert.assertEquals((long)23L, (long)shortValueAccessor.getRawValue());
        Assert.assertEquals((long)24L, (long)shortValueAccessor.getGridPointId());
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarShort("theShort");
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarInt("Grid_point_identifier");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{structureData});
    }

    @Test
    public void testRead_byteValueAccessor() {
        StructureData structureData = (StructureData)Mockito.mock(StructureData.class);
        Mockito.when((Object)structureData.getScalarByte("theByte")).thenReturn((Object)25);
        Mockito.when((Object)structureData.getScalarInt("Grid_point_identifier")).thenReturn((Object)26);
        ValueAccessors.ByteValueAccessor byteValueAccessor = new ValueAccessors.ByteValueAccessor("theByte");
        byteValueAccessor.read(structureData);
        Assert.assertEquals((long)25L, (long)byteValueAccessor.getRawValue());
        Assert.assertEquals((long)26L, (long)byteValueAccessor.getGridPointId());
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarByte("theByte");
        ((StructureData)Mockito.verify((Object)structureData, (VerificationMode)Mockito.times((int)1))).getScalarInt("Grid_point_identifier");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{structureData});
    }
}

