/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import java.io.File;
import org.esa.smos.dataio.smos.bufr.SmosLightBufrReader;
import org.esa.smos.dataio.smos.bufr.SmosLightBufrReaderPlugIn;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SmosLightBufrReaderPlugInTest {
    private SmosLightBufrReaderPlugIn plugin;

    @Before
    public void setUp() {
        this.plugin = new SmosLightBufrReaderPlugIn();
    }

    @Test
    public void testGetDecodeQualification() {
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)"W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v505.bin"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)"W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v505.bin.bz2"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)new File("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v505.bin")));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)new File("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v505.bin.bz2")));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)"W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v620.bin"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)"W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v620.bin.bz2"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)new File("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v620.bin")));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)new File("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028030552_20131028003256_20131028020943_bufr_v620.bin.bz2")));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)new File("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20140626184247_20110505233004_20110506011209_bufr_v620.bin.bz2")));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugin.getDecodeQualification((Object)new File("firle.fanz")));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugin.getDecodeQualification((Object)"smos_file.txt"));
    }

    @Test
    public void testGetInputTypes() {
        Class[] inputTypes = this.plugin.getInputTypes();
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(File.class, (Object)inputTypes[0]);
        Assert.assertEquals(String.class, (Object)inputTypes[1]);
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.plugin.getFormatNames();
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"SMOS Light-BUFR", (Object)formatNames[0]);
    }

    @Test
    public void testGetDefaultFileExtensions() {
        String[] extensions = this.plugin.getDefaultFileExtensions();
        Assert.assertEquals((long)2L, (long)extensions.length);
        Assert.assertEquals((Object)".bin", (Object)extensions[0]);
        Assert.assertEquals((Object)".bin.bz2", (Object)extensions[1]);
    }

    @Test
    public void testGetDescription() {
        Assert.assertEquals((Object)"SMOS Light-BUFR data products", (Object)this.plugin.getDescription(null));
    }

    @Test
    public void testGetProductFileFilter() {
        SnapFileFilter productFileFilter = this.plugin.getProductFileFilter();
        Assert.assertNotNull((Object)productFileFilter);
        Assert.assertEquals((Object)".bin", (Object)productFileFilter.getDefaultExtension());
        Assert.assertEquals((Object)"SMOS Light-BUFR", (Object)productFileFilter.getFormatName());
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader reader = this.plugin.createReaderInstance();
        Assert.assertNotNull((Object)reader);
        Assert.assertTrue((boolean)(reader instanceof SmosLightBufrReader));
    }
}

