/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import java.io.File;
import org.esa.smos.dataio.smos.bufr.SmosBufrReader;
import org.esa.smos.dataio.smos.bufr.SmosBufrReaderPlugIn;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SmosBufrReaderPlugInTest {
    private SmosBufrReaderPlugIn plugin;

    @Before
    public void setUp() {
        this.plugin = new SmosBufrReaderPlugIn();
    }

    @Test
    public void testGetDecodeQualification() {
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)"miras_20131028_003256_20131028_020943_smos_20947_o_20131028_031005_l1c.bufr"));
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugin.getDecodeQualification((Object)new File("miras_20131028_003256_20131028_020943_smos_20947_o_20131028_031005_l1c.bufr")));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugin.getDecodeQualification((Object)new File("firle.fanz")));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugin.getDecodeQualification((Object)"smos_file.txt"));
    }

    @Test
    public void testGetInputTypes() {
        Class[] inputTypes = this.plugin.getInputTypes();
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(File.class, (Object)inputTypes[0]);
        Assert.assertEquals(String.class, (Object)inputTypes[1]);
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.plugin.getFormatNames();
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"SMOS BUFR", (Object)formatNames[0]);
    }

    @Test
    public void testGetDefaultFileExtensions() {
        String[] extensions = this.plugin.getDefaultFileExtensions();
        Assert.assertEquals((long)1L, (long)extensions.length);
        Assert.assertEquals((Object)".bufr", (Object)extensions[0]);
    }

    @Test
    public void testGetDescription() {
        Assert.assertEquals((Object)"SMOS BUFR data products", (Object)this.plugin.getDescription(null));
    }

    @Test
    public void testGetProductFileFilter() {
        SnapFileFilter productFileFilter = this.plugin.getProductFileFilter();
        Assert.assertNotNull((Object)productFileFilter);
        Assert.assertEquals((Object)".bufr", (Object)productFileFilter.getDefaultExtension());
        Assert.assertEquals((Object)"SMOS BUFR", (Object)productFileFilter.getFormatName());
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader reader = this.plugin.createReaderInstance();
        Assert.assertNotNull((Object)reader);
        Assert.assertTrue((boolean)(reader instanceof SmosBufrReader));
    }
}

