/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import org.esa.smos.dataio.smos.bufr.SmosBufrFile;
import org.junit.Assert;
import org.junit.Test;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;

public class SmosBufrFileTest {
    @Test
    public void testOpenAndIterateMessages() throws IOException, URISyntaxException {
        URL resource = this.getClass().getResource("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028033037_20131028002942_20131028003302_bufr_v505.bin");
        File file = new File(resource.toURI());
        try (SmosBufrFile dataset = SmosBufrFile.open((String)file.getPath());){
            int messageCount = dataset.getMessageCount();
            Assert.assertEquals((long)162L, (long)messageCount);
            for (int i = 1; i < messageCount; i += 100) {
                StructureDataIterator structureIterator = dataset.getStructureIterator(i);
                while (structureIterator.hasNext()) {
                    StructureData structureData = structureIterator.next();
                    Assert.assertNotNull((Object)structureData);
                    List members = structureData.getMembers();
                    Assert.assertEquals((long)33L, (long)members.size());
                    Array gridPointCountData = structureData.getArray("Number_of_grid_points");
                    Assert.assertNotNull((Object)gridPointCountData);
                    Array gridPointIdentifierData = structureData.getArray("Grid_point_identifier");
                    Assert.assertNotNull((Object)gridPointIdentifierData);
                    Assert.assertEquals((long)1L, (long)gridPointIdentifierData.getSize());
                    Array snapshotIdentifierData = structureData.getArray("Snapshot_identifier");
                    Assert.assertNotNull((Object)snapshotIdentifierData);
                    Assert.assertEquals((long)1L, (long)snapshotIdentifierData.getSize());
                    Array brightnessTemperatureRealPartData = structureData.getArray("Brightness_temperature_real_part");
                    Assert.assertNotNull((Object)brightnessTemperatureRealPartData);
                    Assert.assertEquals((long)1L, (long)brightnessTemperatureRealPartData.getSize());
                }
            }
        }
    }

    @Test
    public void testOpenAndIterateMessages_bz2() throws IOException, URISyntaxException {
        URL resource = this.getClass().getResource("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028033037_20131028002942_20131028003302_bufr_v505.bin.bz2");
        File file = new File(resource.toURI());
        try (SmosBufrFile dataset = SmosBufrFile.open((String)file.getPath());){
            int messageCount = dataset.getMessageCount();
            Assert.assertEquals((long)162L, (long)messageCount);
            for (int i = 1; i < messageCount; i += 100) {
                StructureDataIterator structureIterator = dataset.getStructureIterator(i);
                while (structureIterator.hasNext()) {
                    StructureData structureData = structureIterator.next();
                    Assert.assertNotNull((Object)structureData);
                    List members = structureData.getMembers();
                    Assert.assertEquals((long)33L, (long)members.size());
                    Array gridPointCountData = structureData.getArray("Number_of_grid_points");
                    Assert.assertNotNull((Object)gridPointCountData);
                    Array gridPointIdentifierData = structureData.getArray("Grid_point_identifier");
                    Assert.assertNotNull((Object)gridPointIdentifierData);
                    Assert.assertEquals((long)1L, (long)gridPointIdentifierData.getSize());
                    Array snapshotIdentifierData = structureData.getArray("Snapshot_identifier");
                    Assert.assertNotNull((Object)snapshotIdentifierData);
                    Assert.assertEquals((long)1L, (long)snapshotIdentifierData.getSize());
                    Array brightnessTemperatureRealPartData = structureData.getArray("Brightness_temperature_real_part");
                    Assert.assertNotNull((Object)brightnessTemperatureRealPartData);
                    Assert.assertEquals((long)1L, (long)brightnessTemperatureRealPartData.getSize());
                }
            }
        }
    }

    @Test
    public void testGetLengthOfImageInputStream() throws Exception {
        URL resource = this.getClass().getResource("W_ES-ESA-ESAC,SMOS,N256_C_LEMM_20131028033037_20131028002942_20131028003302_bufr_v505.bin.bz2");
        File file = new File(resource.toURI());
        InputStream inputStream = SmosBufrFile.createInputStream((File)file);
        try (ImageInputStream imageInputStream = SmosBufrFile.createImageInputStream((InputStream)inputStream);){
            Assert.assertEquals((long)4244180L, (long)SmosBufrFile.getLength((ImageInputStream)imageInputStream));
        }
    }
}

