/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.io.File;
import org.esa.smos.dataio.smos.SmosProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SmosProductReaderPluginTest {
    private SmosProductReaderPlugIn plugIn;

    @Before
    public void setUp() {
        this.plugIn = new SmosProductReaderPlugIn();
    }

    @Test
    public void testGetInputTypes() {
        Class[] inputTypes = this.plugIn.getInputTypes();
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(File.class, (Object)inputTypes[0]);
        Assert.assertEquals(String.class, (Object)inputTypes[1]);
    }

    @Test
    public void testGetDefaultFileExtensions() {
        String[] extensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertEquals((long)4L, (long)extensions.length);
        Assert.assertEquals((Object)".HDR", (Object)extensions[0]);
        Assert.assertEquals((Object)".DBL", (Object)extensions[1]);
        Assert.assertEquals((Object)".zip", (Object)extensions[2]);
        Assert.assertEquals((Object)".ZIP", (Object)extensions[3]);
    }

    @Test
    public void testGetDescription() {
        String description = this.plugIn.getDescription(null);
        Assert.assertEquals((Object)"SMOS Data Products", (Object)description);
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"SMOS-EEF", (Object)formatNames[0]);
    }

    @Test
    public void testGetProductFileFilter() {
        SnapFileFilter productFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])productFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)productFileFilter.getFormatName());
        Assert.assertEquals((Object)"SMOS Data Products (*.HDR,*.DBL,*.zip,*.ZIP)", (Object)productFileFilter.getDescription());
    }
}

