/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ProductHelperTest {
    public static final String VIRTUAL_BAND_NAME = "the_virtual_band";
    private Product product;
    private BandDescriptor bandDescriptor;

    @Before
    public void setUp() {
        this.product = new Product("bla", "test-Type", 2, 3);
        this.bandDescriptor = (BandDescriptor)Mockito.mock(BandDescriptor.class);
        Mockito.when((Object)this.bandDescriptor.getBandName()).thenReturn((Object)VIRTUAL_BAND_NAME);
        Mockito.when((Object)this.bandDescriptor.hasTypicalMin()).thenReturn((Object)true);
        Mockito.when((Object)this.bandDescriptor.getTypicalMin()).thenReturn((Object)0.2);
        Mockito.when((Object)this.bandDescriptor.hasTypicalMax()).thenReturn((Object)true);
        Mockito.when((Object)this.bandDescriptor.getTypicalMax()).thenReturn((Object)1.2);
    }

    @Test
    public void testAddVirtualBand_bandDescriptionIsAdded() {
        Mockito.when((Object)this.bandDescriptor.getDescription()).thenReturn((Object)"the virtual description");
        ProductHelper.addVirtualBand((Product)this.product, (BandDescriptor)this.bandDescriptor, (String)"2 * source_band");
        Band band = this.product.getBand(VIRTUAL_BAND_NAME);
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"the virtual description", (Object)band.getDescription());
    }

    @Test
    public void testAddVirtualBand_unitIsAdded() {
        Mockito.when((Object)this.bandDescriptor.getUnit()).thenReturn((Object)"it's virtual");
        ProductHelper.addVirtualBand((Product)this.product, (BandDescriptor)this.bandDescriptor, (String)"2 * source_band");
        Band band = this.product.getBand(VIRTUAL_BAND_NAME);
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"it's virtual", (Object)band.getUnit());
    }

    @Test
    public void testAddVirtualBand_fillValueIsAdded() {
        Mockito.when((Object)this.bandDescriptor.getFillValue()).thenReturn((Object)123.78);
        ProductHelper.addVirtualBand((Product)this.product, (BandDescriptor)this.bandDescriptor, (String)"2 * source_band");
        Band band = this.product.getBand(VIRTUAL_BAND_NAME);
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((double)123.78, (double)band.getGeophysicalNoDataValue(), (double)1.0E-5);
    }

    @Test
    public void testAddVirtualBand_hasFillValueIsAdded() {
        Mockito.when((Object)this.bandDescriptor.hasFillValue()).thenReturn((Object)true);
        ProductHelper.addVirtualBand((Product)this.product, (BandDescriptor)this.bandDescriptor, (String)"2 * source_band");
        Band band = this.product.getBand(VIRTUAL_BAND_NAME);
        Assert.assertNotNull((Object)band);
        Assert.assertTrue((boolean)band.isNoDataValueUsed());
    }

    @Test
    public void testCreateImageInfo_SoilMoisture() {
        Mockito.when((Object)this.bandDescriptor.getBandName()).thenReturn((Object)"Soil_Moisture");
        ImageInfo imageInfo = ProductHelper.createImageInfo(null, (BandDescriptor)this.bandDescriptor);
        Assert.assertNotNull((Object)imageInfo);
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        ColorPaletteDef.Point[] points = colorPaletteDef.getPoints();
        Assert.assertEquals((long)5L, (long)points.length);
        Assert.assertEquals((Object)new Color(255, 136, 0), (Object)points[0].getColor());
        Assert.assertEquals((double)0.0, (double)points[0].getSample(), (double)1.0E-8);
        Assert.assertEquals((Object)new Color(225, 221, 0), (Object)points[2].getColor());
        Assert.assertEquals((double)0.1, (double)points[2].getSample(), (double)1.0E-8);
    }

    @Test
    public void testCreateImageInfo_TauNad() {
        Mockito.when((Object)this.bandDescriptor.getBandName()).thenReturn((Object)"Tau_Nad_FO");
        ImageInfo imageInfo = ProductHelper.createImageInfo(null, (BandDescriptor)this.bandDescriptor);
        Assert.assertNotNull((Object)imageInfo);
        this.assertTauNadColourPalette(imageInfo);
        Mockito.when((Object)this.bandDescriptor.getBandName()).thenReturn((Object)"Tau_Nad_FV");
        imageInfo = ProductHelper.createImageInfo(null, (BandDescriptor)this.bandDescriptor);
        Assert.assertNotNull((Object)imageInfo);
        this.assertTauNadColourPalette(imageInfo);
    }

    @Test
    public void testCreateProduct() {
        File file = new File("nasenmann-file.zip");
        String productType = "NAS_MAN";
        Product product = ProductHelper.createProduct((File)file, (String)"NAS_MAN");
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((Object)"nasenmann-file", (Object)product.getName());
        Assert.assertEquals((Object)"NAS_MAN", (Object)product.getProductType());
        Dimension rasterDimension = ProductHelper.getSceneRasterDimension();
        Assert.assertEquals((long)rasterDimension.width, (long)product.getSceneRasterWidth());
        Assert.assertEquals((long)rasterDimension.height, (long)product.getSceneRasterHeight());
        File productFile = product.getFileLocation();
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)productFile.getAbsolutePath());
        Dimension preferredTileSize = product.getPreferredTileSize();
        Assert.assertNotNull((Object)preferredTileSize);
        Assert.assertEquals((long)512L, (long)preferredTileSize.width);
        Assert.assertEquals((long)512L, (long)preferredTileSize.height);
        GeoCoding geoCoding = product.getSceneGeoCoding();
        Assert.assertNotNull((Object)geoCoding);
    }

    private void assertTauNadColourPalette(ImageInfo imageInfo) {
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        ColorPaletteDef.Point[] points = colorPaletteDef.getPoints();
        Assert.assertEquals((long)3L, (long)points.length);
        Assert.assertEquals((Object)new Color(213, 255, 135), (Object)points[0].getColor());
        Assert.assertEquals((double)0.0, (double)points[0].getSample(), (double)1.0E-8);
        Assert.assertEquals((Object)new Color(0, 45, 0), (Object)points[2].getColor());
        Assert.assertEquals((double)1.2, (double)points[2].getSample(), (double)1.0E-8);
    }
}

