/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.awt.geom.Rectangle2D;
import org.esa.smos.dataio.smos.Grid;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.support.ReducedGaussianGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridTest {
    private Grid grid;

    @Before
    public void setUp() {
        this.grid = new Grid((PlanetaryGrid)new ReducedGaussianGrid(512));
    }

    @Test
    public void testGetCellIndex_fromGeoLocation() {
        Assert.assertEquals((long)9L, (long)this.grid.getCellIndex(-180.0, 90.0));
        Assert.assertEquals((long)51989L, (long)this.grid.getCellIndex(179.0, 45.0));
        Assert.assertEquals((long)174264L, (long)this.grid.getCellIndex(0.0, 0.0));
        Assert.assertEquals((long)348519L, (long)this.grid.getCellIndex(-180.0, -90.0));
        Assert.assertEquals((long)296535L, (long)this.grid.getCellIndex(179.0, -45.0));
    }

    @Test
    public void testGetCellIndex_fromLevelledXandY() {
        Assert.assertEquals((long)95L, (long)this.grid.getCellIndex(0, 0, 0));
        Assert.assertEquals((long)185L, (long)this.grid.getCellIndex(30, 30, 0));
        Assert.assertEquals((long)302L, (long)this.grid.getCellIndex(30, 30, 1));
        Assert.assertEquals((long)594L, (long)this.grid.getCellIndex(30, 30, 2));
        Assert.assertEquals((long)1332L, (long)this.grid.getCellIndex(30, 30, 3));
    }

    @Test
    public void testGetGridRect() {
        Rectangle2D gridRect = this.grid.getGridRect(0.0, 0.0);
        Assert.assertEquals((double)-0.17578125, (double)gridRect.getX(), (double)1.0E-8);
        Assert.assertEquals((double)-0.17578125, (double)gridRect.getY(), (double)1.0E-8);
        Assert.assertEquals((double)0.3515625, (double)gridRect.getWidth(), (double)1.0E-8);
        Assert.assertEquals((double)0.3515625, (double)gridRect.getHeight(), (double)1.0E-8);
        gridRect = this.grid.getGridRect(-60.0, 0.0);
        Assert.assertEquals((double)-60.17578125, (double)gridRect.getX(), (double)1.0E-8);
        Assert.assertEquals((double)-0.17578125, (double)gridRect.getY(), (double)1.0E-8);
        Assert.assertEquals((double)0.3515625, (double)gridRect.getWidth(), (double)1.0E-8);
        Assert.assertEquals((double)0.3515625, (double)gridRect.getHeight(), (double)1.0E-8);
        gridRect = this.grid.getGridRect(0.0, -30.0);
        Assert.assertEquals((double)-0.1875, (double)gridRect.getX(), (double)1.0E-8);
        Assert.assertEquals((double)-30.17578125, (double)gridRect.getY(), (double)1.0E-8);
        Assert.assertEquals((double)0.375, (double)gridRect.getWidth(), (double)1.0E-8);
        Assert.assertEquals((double)0.3515625, (double)gridRect.getHeight(), (double)1.0E-8);
    }
}

