/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.util.HashMap;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.junit.Assert;
import org.junit.Test;

public class GridPointBtDatasetTest {
    @Test
    public void testGetColumnIndex() {
        GridPointBtDataset gridPointBtDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)1L, (long)gridPointBtDataset.getColumnIndex("Willy"));
        Assert.assertEquals((long)3L, (long)gridPointBtDataset.getColumnIndex("Hermann"));
        Assert.assertEquals((long)-1L, (long)gridPointBtDataset.getColumnIndex("Adele"));
    }

    @Test
    public void testGetClasses() {
        GridPointBtDataset gridPointBtDataset = this.createGridPointBtDataset();
        Class[] columnClasses = gridPointBtDataset.getColumnClasses();
        Assert.assertEquals((long)2L, (long)columnClasses.length);
        Assert.assertEquals(Double.class, (Object)columnClasses[1]);
    }

    @Test
    public void testGetData() {
        GridPointBtDataset gridPointBtDataset = this.createGridPointBtDataset();
        Number[][] data = gridPointBtDataset.getData();
        Assert.assertEquals((long)2L, (long)data.length);
        Assert.assertEquals((Object)1, (Object)data[0][0]);
        Assert.assertEquals((Object)4, (Object)data[1][1]);
    }

    private GridPointBtDataset createGridPointBtDataset() {
        HashMap<String, Integer> memberNamesMap = new HashMap<String, Integer>();
        memberNamesMap.put("Willy", 1);
        memberNamesMap.put("Charlotte", 2);
        memberNamesMap.put("Hermann", 3);
        memberNamesMap.put("Astrid", 4);
        Class[] classes = new Class[]{String.class, Double.class};
        Number[][] data = new Number[][]{{1, 2}, {3, 4}};
        return new GridPointBtDataset(memberNamesMap, classes, data);
    }

    @Test
    public void testSetGetFlagBandIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        btDataset.setFlagBandIndex(28);
        Assert.assertEquals((long)28L, (long)btDataset.getFlagBandIndex());
    }

    @Test
    public void testGetFlagBandIndex_defaultValue() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)-1L, (long)btDataset.getFlagBandIndex());
    }

    @Test
    public void testSetGetPolarisationFlagBandIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        btDataset.setPolarisationFlagBandIndex(104);
        Assert.assertEquals((long)104L, (long)btDataset.getPolarisationFlagBandIndex());
    }

    @Test
    public void testGetPolarisationFlagBandIndex_defaultValue() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)-1L, (long)btDataset.getPolarisationFlagBandIndex());
    }

    @Test
    public void testSetGetIncidenceAngleBandIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        btDataset.setIncidenceAngleBandIndex(29);
        Assert.assertEquals((long)29L, (long)btDataset.getIncidenceAngleBandIndex());
    }

    @Test
    public void testGetIncidenceAngleBandIndex_defaultValue() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)-1L, (long)btDataset.getIncidenceAngleBandIndex());
    }

    @Test
    public void testSetGetRadiometricAccuracyBandIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        btDataset.setRadiometricAccuracyBandIndex(30);
        Assert.assertEquals((long)30L, (long)btDataset.getRadiometricAccuracyBandIndex());
    }

    @Test
    public void testGetRadiometricAccuracyBandIndex_defaultValue() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)-1L, (long)btDataset.getRadiometricAccuracyBandIndex());
    }

    @Test
    public void testSetGetBTValueRealBandIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        btDataset.setBTValueRealBandIndex(31);
        Assert.assertEquals((long)31L, (long)btDataset.getBTValueRealBandIndex());
    }

    @Test
    public void testGetBTValueRealBandIndex_defaultValue() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)-1L, (long)btDataset.getBTValueRealBandIndex());
    }

    @Test
    public void testSetGetBTValueImaginaryBandIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        btDataset.setBTValueImaginaryBandIndex(32);
        Assert.assertEquals((long)32L, (long)btDataset.getBTValueImaginaryBandIndex());
    }

    @Test
    public void testGetBTValueImaginaryBandIndex_defaultValue() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        Assert.assertEquals((long)-1L, (long)btDataset.getBTValueImaginaryBandIndex());
    }
}

