/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.awt.geom.Rectangle2D;
import org.esa.smos.dataio.smos.DggUtils;
import org.junit.Assert;
import org.junit.Test;

public class DggUtilsTest {
    @Test
    public void testCreateTileRectangle() {
        Rectangle2D rectangle = DggUtils.createTileRectangle((int)0, (int)0);
        Assert.assertEquals((double)-180.0, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)77.51953125, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)11.25, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)11.07421875, (double)rectangle.getHeight(), (double)0.0);
        rectangle = DggUtils.createTileRectangle((int)31, (int)0);
        Assert.assertEquals((double)168.75, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)77.51953125, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)11.25, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)11.07421875, (double)rectangle.getHeight(), (double)0.0);
        rectangle = DggUtils.createTileRectangle((int)31, (int)15);
        Assert.assertEquals((double)168.75, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)-88.59375, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)11.25, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)11.07421875, (double)rectangle.getHeight(), (double)0.0);
    }

    @Test
    public void testCreateGridPointRectangle() {
        Rectangle2D rectangle = DggUtils.createGridPointRectangle((double)34.0, (double)-10.0);
        Assert.assertEquals((double)33.98, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)-10.01, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)0.04, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)rectangle.getHeight(), (double)0.0);
    }

    @Test
    public void testCreateGridPointRectangle_lonCrossesAntiMeridian() {
        Rectangle2D rectangle = DggUtils.createGridPointRectangle((double)-181.0, (double)19.0);
        Assert.assertEquals((double)-180.0, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)18.99, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)0.04, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)rectangle.getHeight(), (double)0.0);
        rectangle = DggUtils.createGridPointRectangle((double)179.99, (double)20.0);
        Assert.assertEquals((double)179.93, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)19.99, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)0.04, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)rectangle.getHeight(), (double)0.0);
    }

    @Test
    public void testCreateGridPointRectangle_latBeyondPole() {
        Rectangle2D rectangle = DggUtils.createGridPointRectangle((double)35.0, (double)-90.2);
        Assert.assertEquals((double)34.98, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)-90.0, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)0.04, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)rectangle.getHeight(), (double)0.0);
        rectangle = DggUtils.createGridPointRectangle((double)36.0, (double)90.0);
        Assert.assertEquals((double)35.98, (double)rectangle.getX(), (double)0.0);
        Assert.assertEquals((double)89.97, (double)rectangle.getY(), (double)0.0);
        Assert.assertEquals((double)0.04, (double)rectangle.getWidth(), (double)0.0);
        Assert.assertEquals((double)0.02, (double)rectangle.getHeight(), (double)0.0);
    }
}

