/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.lsmask;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.esa.snap.core.image.TiledFileMultiLevelSource;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;

public class SmosLsMask {
    private static final String SMOS_LS_MASK_DIR_PROPERTY_NAME = "org.esa.smos.lsMaskDir";
    private final MultiLevelImage multiLevelImage;

    public static SmosLsMask getInstance() {
        return Holder.INSTANCE;
    }

    public MultiLevelImage getMultiLevelImage() {
        return this.multiLevelImage;
    }

    private SmosLsMask() {
        try {
            Path dirPath = SmosLsMask.getDirPathFromProperty();
            if (dirPath == null) {
                dirPath = SmosLsMask.getLsMaskAuxdataPath();
            }
            this.installLsMaskFiles(dirPath);
            TiledFileMultiLevelSource multiLevelSource = TiledFileMultiLevelSource.create((Path)dirPath);
            this.multiLevelImage = new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource);
        }
        catch (Exception e) {
            throw new IllegalStateException(MessageFormat.format("Cannot create SMOS Land/Sea Mask multi-level image: {0}", e.getMessage()), e);
        }
    }

    private static Path getPathFromModule() throws URISyntaxException, IOException {
        return ResourceInstaller.findModuleCodeBasePath(SmosLsMask.class);
    }

    private void installLsMaskFiles(Path auxdataPath) throws IOException, URISyntaxException {
        Path resolve = SmosLsMask.getPathFromModule().resolve("org/esa/smos/lsmask");
        new ResourceInstaller(resolve, auxdataPath).install(".*(zip|properties)", ProgressMonitor.NULL);
    }

    private static Path getLsMaskAuxdataPath() {
        return SystemUtils.getAuxDataPath().resolve("smos-lsmask/mask-tiles");
    }

    private static Path getDirPathFromProperty() throws IOException {
        String dirPath = System.getProperty(SMOS_LS_MASK_DIR_PROPERTY_NAME);
        if (dirPath != null) {
            Path dir = Paths.get(dirPath, new String[0]);
            if (!Files.isReadable(dir)) {
                throw new IOException(MessageFormat.format("Cannot read directory ''{0}''. System property ''{0}'' must point to a readable directory.", dir, SMOS_LS_MASK_DIR_PROPERTY_NAME));
            }
            return dir;
        }
        return null;
    }

    private static class Holder {
        private static final SmosLsMask INSTANCE = new SmosLsMask();

        private Holder() {
        }
    }
}

