/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;

class PixelCoordinateInterpolator {
    PixelCoordinateInterpolator() {
    }

    static void searchScanPixelADS(int[] scanAndPixelIndices, int s0, ProductNodeGroup<MetadataElement> scanPixelADS, int firstPixelNumber, double[] pixelCoordinatesAndTime) {
        int numberOfADSRecords;
        int s = scanAndPixelIndices[0];
        int p = scanAndPixelIndices[1];
        int sg = (int)Math.floor(((double)s - (double)s0) / 32.0);
        if (sg < 0) {
            sg = 0;
        }
        if (sg > (numberOfADSRecords = scanPixelADS.getNodeCount()) - 1) {
            sg = numberOfADSRecords - 1;
        }
        MetadataElement scanADSRecord = (MetadataElement)scanPixelADS.get(sg);
        int instrumentScanNumberCheck = 32 * sg + s0;
        int currentRecordScanNumber = scanADSRecord.getAttributeAt(2).getData().getElemInt();
        if (currentRecordScanNumber != instrumentScanNumberCheck) {
            System.out.println("Data Gaps are present in Scan Pixel ADS");
            System.exit(1);
        }
        int relativePixelIndex = p - firstPixelNumber;
        double tiePixelPart = (double)relativePixelIndex / 10.0;
        int tiePixel = (int)Math.floor(tiePixelPart);
        double weight = tiePixelPart - (double)tiePixel;
        if (relativePixelIndex > 570) {
            weight = (double)(relativePixelIndex - 570) / 4.0;
        }
        if (firstPixelNumber > 1000) {
            tiePixel += 59;
        }
        MetadataAttribute tiePixXList = scanADSRecord.getAttributeAt(3);
        int[] xCoordinateList = (int[])tiePixXList.getDataElems();
        MetadataAttribute tiePixYList = scanADSRecord.getAttributeAt(4);
        int[] yCoordinateList = (int[])tiePixYList.getDataElems();
        double xCoord = (1.0 - weight) * (double)xCoordinateList[tiePixel] + weight * (double)xCoordinateList[tiePixel + 1];
        double yCoord = (1.0 - weight) * (double)yCoordinateList[tiePixel] + weight * (double)yCoordinateList[tiePixel + 1];
        if (s != currentRecordScanNumber && s > s0 && sg < numberOfADSRecords - 1) {
            MetadataElement scanADSRecord2 = (MetadataElement)scanPixelADS.get(sg + 1);
            int nextRecordScanNumber = scanADSRecord2.getAttributeAt(2).getData().getElemInt();
            tiePixXList = scanADSRecord2.getAttributeAt(3);
            xCoordinateList = (int[])tiePixXList.getDataElems();
            tiePixYList = scanADSRecord2.getAttributeAt(4);
            yCoordinateList = (int[])tiePixYList.getDataElems();
            double xCoordNext = (1.0 - weight) * (double)xCoordinateList[tiePixel] + weight * (double)xCoordinateList[tiePixel + 1];
            double yCoordNext = (1.0 - weight) * (double)yCoordinateList[tiePixel] + weight * (double)yCoordinateList[tiePixel + 1];
            xCoord += (double)(s - currentRecordScanNumber) * (xCoordNext - xCoord) / (double)(nextRecordScanNumber - currentRecordScanNumber);
            yCoord += (double)(s - currentRecordScanNumber) * (yCoordNext - yCoord) / (double)(nextRecordScanNumber - currentRecordScanNumber);
        }
        double pixelTime = PixelCoordinateInterpolator.solvePixelTime(scanADSRecord, s, sg, s0, p, currentRecordScanNumber);
        pixelCoordinatesAndTime[0] = xCoord;
        pixelCoordinatesAndTime[1] = yCoord;
        pixelCoordinatesAndTime[2] = pixelTime;
    }

    private static double solvePixelTime(MetadataElement scanADSRecord, int s, int sg, int s0, int p, int currentRecordScanNumber) {
        ProductData dsrTime = scanADSRecord.getAttributeAt(0).getData();
        double scanTime = (double)dsrTime.getElemIntAt(0) + dsrTime.getElemDoubleAt(1) / 86400.0 + dsrTime.getElemDoubleAt(2) / 1000000.0 / 86400.0;
        if (s != currentRecordScanNumber && s > s0) {
            double scanTimeAlongTrackMod = 0.15 * (double)(s - 32 * sg - s0) / 86400.0;
            scanTime += scanTimeAlongTrackMod;
        }
        double scanTimeModScan = (double)(p - 1) * 7.5E-5 / 86400.0;
        double pixelSampleTime = scanTime + scanTimeModScan;
        return pixelSampleTime;
    }

    static void convertCentreLocationToReference(double[] pixelCoordinatesAndTime, int i, ProductNodeGroup<MetadataElement> geolocationADS) {
        pixelCoordinatesAndTime[0] = pixelCoordinatesAndTime[0] - 500.0;
        int sg = (int)Math.floor(((double)i - 0.0) / 32.0);
        int lastADSCoordinate = ((MetadataElement)geolocationADS.get(sg)).getAttribute("img_scan_y").getData().getElemInt();
        int nextADSCoordinate = sg + 1 < geolocationADS.getNodeCount() ? ((MetadataElement)geolocationADS.get(sg + 1)).getAttribute("img_scan_y").getData().getElemInt() : (lastADSCoordinate += 32352);
        double averagePixelSpacing = (double)(nextADSCoordinate - lastADSCoordinate) / 32.0;
        double currentPixelCoordinate = (double)lastADSCoordinate + (double)(i - sg * 32) * averagePixelSpacing;
        double nextPixelCoordinate = (double)lastADSCoordinate + (double)(i + 1 - sg * 32) * averagePixelSpacing;
        double stepSizeY = (nextPixelCoordinate - currentPixelCoordinate) / 2.0;
        pixelCoordinatesAndTime[1] = pixelCoordinatesAndTime[1] - stepSizeY;
    }
}

