/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.esa.s3tbx.aatsr.regrid.Calculator;

public class FOVContour {
    Coordinate[] coordinates;
    double pixelAcrossDistance;
    double pixelAlongDistance;

    public void createContour(double maxAcrossTrackIndex, double maxAlongTrackIndex, double minAcrossTrackIndex, double minAlongTrackIndex, double[] FOVResponse, double extent) {
        int width = (int)(maxAcrossTrackIndex - minAcrossTrackIndex + 1.0);
        int height = (int)(maxAlongTrackIndex - minAlongTrackIndex + 1.0);
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)width, (int)height, (int)1);
        TiledImage tiledImage = new TiledImage(0, 0, width, height, 0, 0, sampleModel, null);
        WritableRaster wr = tiledImage.getWritableTile(0, 0);
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                wr.setSample(w, h, 0, FOVResponse[w + h * width]);
            }
        }
        ParameterBlockJAI pb = new ParameterBlockJAI("Contour");
        pb.setSource("source0", (Object)tiledImage);
        List<Double> levels = Arrays.asList(extent);
        pb.setParameter("levels", levels);
        pb.setParameter("smooth", (Object)Boolean.TRUE);
        RenderedOp dest = JAI.create((String)"Contour", (ParameterBlock)pb);
    }

    public void getExtent(double[] acrossTrackAngleArray, double[] alongTrackAngleArray) {
        double maxX = this.coordinates[0].x;
        double maxY = this.coordinates[0].y;
        double minX = maxX;
        double minY = maxY;
        for (Coordinate coordinate : this.coordinates) {
            double x = coordinate.x;
            double y = coordinate.y;
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (x < minX) {
                minX = x;
            }
            if (!(y < minY)) continue;
            minY = y;
        }
        double acrossDistance1 = Calculator.linearInterp(Math.floor(maxX), Math.ceil(maxX), acrossTrackAngleArray[(int)Math.floor(maxX)], acrossTrackAngleArray[(int)Math.ceil(maxX)], maxX);
        double acrossDistance2 = Calculator.linearInterp(Math.floor(minX), Math.ceil(minX), acrossTrackAngleArray[(int)Math.floor(minX)], acrossTrackAngleArray[(int)Math.ceil(minX)], minX);
        this.pixelAcrossDistance = acrossDistance1 - acrossDistance2;
        double alongDistance1 = Calculator.linearInterp(Math.floor(maxY), Math.ceil(maxY), alongTrackAngleArray[(int)Math.floor(maxY)], alongTrackAngleArray[(int)Math.ceil(maxY)], maxY);
        double alongDistance2 = Calculator.linearInterp(Math.floor(minY), Math.ceil(minY), alongTrackAngleArray[(int)Math.floor(minY)], alongTrackAngleArray[(int)Math.ceil(minY)], minY);
        this.pixelAlongDistance = alongDistance1 - alongDistance2;
    }
}

