/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.aatsr.regrid.Calculator;
import org.esa.s3tbx.aatsr.regrid.InputParameters;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(description="Ungrids (A)ATSR L1B products and extracts geolocation and pixel field of view data.", alias="AATSR.Ungrid", authors="Alasdhair Beaton, Philip Beavis", version="1.0", category="Optical/Geometric", label="AATSR Ungridding", copyright="(c) 2016 by Telespazio VEGA UK Ltd.")
public class AatsrUngriddingOp
extends PixelOperator {
    @SourceProduct(description="(A)ATSR-1/2 source product (Envisat *.N1 format)")
    Product sourceProduct;
    @TargetProduct(description="e.g. hdf5 or netcdf4 cf")
    Product targetProduct;
    @Parameter(notNull=false, description="L1B characterisation file is needed to specify first forward pixel and first nadir pixel")
    private File L1BCharacterisationFile;
    @Parameter(label="Use pixel corner as reference", defaultValue="true", description="Choose the pixel coordinate reference point for use in the output file. \nCheck for Corner (default), un-check for Centre.")
    private boolean cornerReferenceFlag = true;
    @Parameter(label="Topographic corrections to tie points", defaultValue="false", description="Option to apply topographic corrections to tie points")
    private boolean topographicFlag = false;
    @Parameter(defaultValue="0.05", description="Distance (image coordinates) pixel can be from tie-point to have topo correction applied")
    private double topographyHomogenity = 0.05;
    private boolean enableFOV = false;
    private File FOVMeasurementFile;
    private double pixelIFOVReportingExtent = 0.4;
    private InputParameters parameters;
    private ProductNodeGroup<MetadataElement> NADIR_VIEW_SCAN_PIX_NUM_ADS_Records;
    private ProductNodeGroup<MetadataElement> FWARD_VIEW_SCAN_PIX_NUM_ADS_Records;
    private ProductNodeGroup<MetadataElement> SCAN_PIXEL_X_AND_Y_ADS_Records;
    private ProductNodeGroup<MetadataElement> GEOLOCATION_ADS_Records;
    private List<Double> scanYCoords;
    private int s0;
    private List<List<Double>> pixelProjectionMap;
    private static final int PIXELS_PER_ROW = 512;
    private static final int DEFAULT_FIRST_FORWARD_PIXEL = 1305;
    private static final int DEFAULT_FIRST_NADIR_PIXEL = 213;

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        if (!this.sourceProduct.getProductType().equals("ATS_TOA_1P")) {
            throw new OperatorException("Product does not have correct type");
        }
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        this.prepareInputParameters();
        this.prepareMetadata();
        if (this.enableFOV) {
            this.pixelProjectionMap = new ArrayList<List<Double>>();
            Calculator.getConstantPixelProjection(this.parameters, this.pixelProjectionMap);
        }
    }

    protected Product createTargetProduct() throws OperatorException {
        Product targetProduct = super.createTargetProduct();
        Band nadirViewLatitudeBand = targetProduct.addBand("latitude_nadir", 30);
        nadirViewLatitudeBand.setDescription("Latitude, nadir view");
        nadirViewLatitudeBand.setUnit("deg");
        AatsrUngriddingOp.setNoDataValues(nadirViewLatitudeBand);
        Band nadirViewLongitudeBand = targetProduct.addBand("longitude_nadir", 30);
        nadirViewLongitudeBand.setDescription("Longitude, nadir view");
        nadirViewLongitudeBand.setUnit("deg");
        AatsrUngriddingOp.setNoDataValues(nadirViewLongitudeBand);
        Band nadirViewTimesBand = targetProduct.addBand("acquisition_time_nadir", 30);
        nadirViewTimesBand.setDescription("Acquisition time, nadir");
        nadirViewTimesBand.setUnit("Days since 1-1-2000 (MJD 2000)");
        AatsrUngriddingOp.setNoDataValues(nadirViewTimesBand);
        Band forwardViewLatitudeBand = targetProduct.addBand("latitude_fward", 30);
        forwardViewLatitudeBand.setDescription("Latitude, forward view");
        forwardViewLatitudeBand.setUnit("deg");
        AatsrUngriddingOp.setNoDataValues(forwardViewLatitudeBand);
        Band forwardViewLongitudeBand = targetProduct.addBand("longitude_fward", 30);
        forwardViewLongitudeBand.setDescription("Longitude, forward view");
        forwardViewLongitudeBand.setUnit("deg");
        AatsrUngriddingOp.setNoDataValues(forwardViewLongitudeBand);
        Band forwardViewTimesBand = targetProduct.addBand("acquisition_time_fward", 30);
        forwardViewTimesBand.setDescription("Acquisition time, fward");
        forwardViewTimesBand.setUnit("Days since 1-1-2000 (MJD 2000)");
        AatsrUngriddingOp.setNoDataValues(forwardViewTimesBand);
        if (this.enableFOV) {
            targetProduct.addBand("Nadir View Pixel FOV Along Track", 30);
            targetProduct.addBand("Nadir View Pixel FOV Across Track", 30);
            targetProduct.addBand("Forward View Pixel FOV Along Track", 30);
            targetProduct.addBand("Forward View Pixel FOV Across Track", 30);
        }
        return targetProduct;
    }

    private static void setNoDataValues(Band band) {
        band.setNoDataValue(-999999.0);
        band.setNoDataValueUsed(true);
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        productConfigurer.copyBands(new String[0]);
        productConfigurer.getTargetProduct().setAutoGrouping("nadir:fward");
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "latitude_nadir");
        sampleConfigurer.defineSample(1, "longitude_nadir");
        sampleConfigurer.defineSample(2, "acquisition_time_nadir");
        sampleConfigurer.defineSample(3, "latitude_fward");
        sampleConfigurer.defineSample(4, "longitude_fward");
        sampleConfigurer.defineSample(5, "acquisition_time_fward");
        if (this.enableFOV) {
            sampleConfigurer.defineSample(6, "Nadir View Pixel FOV Along Track");
            sampleConfigurer.defineSample(7, "Nadir View Pixel FOV Across Track");
            sampleConfigurer.defineSample(8, "Forward View Pixel FOV Along Track");
            sampleConfigurer.defineSample(9, "Forward View Pixel FOV Across Track");
        }
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int pixel = 511 - x;
        int[] pixelRelativeNumbers = new int[]{0, 0};
        double[] pixelNewPositionsAndTimes = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        Calculator.getPixelPositionsAcquisitionTimes(y, pixel, this.s0, this.NADIR_VIEW_SCAN_PIX_NUM_ADS_Records, this.FWARD_VIEW_SCAN_PIX_NUM_ADS_Records, this.SCAN_PIXEL_X_AND_Y_ADS_Records, this.GEOLOCATION_ADS_Records, this.scanYCoords, pixelNewPositionsAndTimes, pixelRelativeNumbers, this.parameters);
        targetSamples[0].set(pixelNewPositionsAndTimes[0]);
        targetSamples[1].set(pixelNewPositionsAndTimes[1]);
        targetSamples[2].set(pixelNewPositionsAndTimes[2]);
        targetSamples[3].set(pixelNewPositionsAndTimes[3]);
        targetSamples[4].set(pixelNewPositionsAndTimes[4]);
        targetSamples[5].set(pixelNewPositionsAndTimes[5]);
        if (this.enableFOV) {
            targetSamples[6].set(this.pixelProjectionMap.get(pixelRelativeNumbers[0]).get(0).doubleValue());
            targetSamples[7].set(this.pixelProjectionMap.get(pixelRelativeNumbers[0]).get(1).doubleValue());
            targetSamples[8].set(this.pixelProjectionMap.get(pixelRelativeNumbers[1]).get(0).doubleValue());
            targetSamples[9].set(this.pixelProjectionMap.get(pixelRelativeNumbers[1]).get(1).doubleValue());
        }
    }

    private void prepareInputParameters() {
        this.parameters = new InputParameters();
        if (this.L1BCharacterisationFile != null) {
            this.parameters.parseCharacterisationFile(this.L1BCharacterisationFile.getPath());
        } else {
            this.parameters.firstForwardPixel = 1305;
            this.parameters.firstNadirPixel = 213;
        }
        if (this.enableFOV) {
            this.parameters.parseRawIFOV(this.FOVMeasurementFile.getPath());
        }
        this.parameters.pixelIFOVReportingExtent = this.pixelIFOVReportingExtent;
        this.parameters.cornerReferenceFlag = this.cornerReferenceFlag;
        this.parameters.topographicFlag = this.topographicFlag;
        this.parameters.topographyHomogenity = this.topographyHomogenity;
    }

    private void prepareMetadata() {
        MetadataElement metadataRoot = this.sourceProduct.getMetadataRoot();
        this.NADIR_VIEW_SCAN_PIX_NUM_ADS_Records = metadataRoot.getElement("NADIR_VIEW_SCAN_PIX_NUM_ADS").getElementGroup();
        this.FWARD_VIEW_SCAN_PIX_NUM_ADS_Records = metadataRoot.getElement("FWARD_VIEW_SCAN_PIX_NUM_ADS").getElementGroup();
        this.SCAN_PIXEL_X_AND_Y_ADS_Records = metadataRoot.getElement("SCAN_PIXEL_X_AND_Y_ADS").getElementGroup();
        this.GEOLOCATION_ADS_Records = metadataRoot.getElement("GEOLOCATION_ADS").getElementGroup();
        this.scanYCoords = new ArrayList<Double>();
        for (int k = 0; k < this.GEOLOCATION_ADS_Records.getNodeCount(); ++k) {
            MetadataElement GeoAdsRecord = (MetadataElement)this.GEOLOCATION_ADS_Records.get(k);
            this.scanYCoords.add(GeoAdsRecord.getAttributeDouble("img_scan_y"));
        }
        MetadataElement firstRecord = (MetadataElement)this.SCAN_PIXEL_X_AND_Y_ADS_Records.get(0);
        MetadataAttribute instr_scan_num = firstRecord.getAttributeAt(2);
        ProductData data = instr_scan_num.getData();
        this.s0 = data.getElemInt();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AatsrUngriddingOp.class);
        }
    }
}

