/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ProductNameMerger;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProductNameMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel3:productName>S3A_SL_1_RBT____20130707T153252_20130707T153752_20150217T183530_0299_158_182______SVL_O_NR_001.SEN3</sentinel3:productName>\n"));
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel3:productName>S3A_SL_1_RBT____20130707T153752_20130707T154252_20150217T183530_0299_158_182______SVL_O_NR_001.SEN3</sentinel3:productName>\n"));
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel3:productName>S3A_SL_1_RBT____20130707T154252_20130707T154752_20150217T183537_0299_158_182______SVL_O_NR_001.SEN3</sentinel3:productName>\n"));
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("sentinel3:productName");
        manifest.appendChild(manifestElement);
        new ProductNameMerger("cevbtvztx").mergeNodes(fromParents, manifestElement, manifest);
        TestCase.assertEquals((int)0, (int)manifestElement.getAttributes().getLength());
        TestCase.assertEquals((int)1, (int)manifestElement.getChildNodes().getLength());
        TestCase.assertEquals((String)"cevbtvztx", (String)manifestElement.getFirstChild().getNodeValue());
    }
}

