/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.OrbitReferenceMerger;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrbitReferenceMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n          <sentinel-safe:orbitReference>\n            <sentinel-safe:orbitNumber groundTrackDirection=\"descending\" type=\"start\">60627</sentinel-safe:orbitNumber>\n            <sentinel-safe:relativeOrbitNumber groundTrackDirection=\"descending\" type=\"start\">182</sentinel-safe:relativeOrbitNumber>\n            <sentinel-safe:passNumber groundTrackDirection=\"descending\" type=\"start\">121254</sentinel-safe:passNumber>\n            <sentinel-safe:relativePassNumber groundTrackDirection=\"descending\" type=\"start\">364</sentinel-safe:relativePassNumber>\n            <sentinel-safe:cycleNumber>158</sentinel-safe:cycleNumber>\n            <sentinel-safe:phaseIdentifier>1</sentinel-safe:phaseIdentifier>\n            <sentinel-safe:elementSet>\n              <sentinel-safe:ephemeris>\n                <sentinel-safe:epoch type=\"UTC\">2013-07-07T14:38:40.174945Z</sentinel-safe:epoch>\n                <sentinel-safe:epoch type=\"UT1\">2013-07-07T14:38:40.233437</sentinel-safe:epoch>\n                <sentinel-safe:epoch type=\"TAI\">2013-07-07T14:39:15.174945</sentinel-safe:epoch>\n                <sentinel-safe:position>\n                  <sentinel-safe:x>-2496716.548</sentinel-safe:x>\n                  <sentinel-safe:y>+6735891.009</sentinel-safe:y>\n                  <sentinel-safe:z>+0000014.370</sentinel-safe:z>\n                </sentinel-safe:position>\n                <sentinel-safe:velocity>\n                  <sentinel-safe:x>+1541.463032</sentinel-safe:x>\n                  <sentinel-safe:y>+0562.236011</sentinel-safe:y>\n                  <sentinel-safe:z>+7366.402657</sentinel-safe:z>\n                </sentinel-safe:velocity>\n              </sentinel-safe:ephemeris>\n            </sentinel-safe:elementSet>\n          </sentinel-safe:orbitReference>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n          <sentinel-safe:orbitReference>\n            <sentinel-safe:orbitNumber groundTrackDirection=\"descending\" type=\"start\">60627</sentinel-safe:orbitNumber>\n            <sentinel-safe:relativeOrbitNumber groundTrackDirection=\"descending\" type=\"start\">182</sentinel-safe:relativeOrbitNumber>\n            <sentinel-safe:passNumber groundTrackDirection=\"descending\" type=\"start\">121254</sentinel-safe:passNumber>\n            <sentinel-safe:relativePassNumber groundTrackDirection=\"descending\" type=\"start\">364</sentinel-safe:relativePassNumber>\n            <sentinel-safe:cycleNumber>158</sentinel-safe:cycleNumber>\n            <sentinel-safe:phaseIdentifier>1</sentinel-safe:phaseIdentifier>\n            <sentinel-safe:elementSet>\n              <sentinel-safe:ephemeris>\n                <sentinel-safe:epoch type=\"UTC\">2013-07-07T14:38:40.174945Z</sentinel-safe:epoch>\n                <sentinel-safe:epoch type=\"UT1\">2013-07-07T14:38:40.233437</sentinel-safe:epoch>\n                <sentinel-safe:epoch type=\"TAI\">2013-07-07T14:39:15.174945</sentinel-safe:epoch>\n                <sentinel-safe:position>\n                  <sentinel-safe:x>-2496716.548</sentinel-safe:x>\n                  <sentinel-safe:y>+6735891.009</sentinel-safe:y>\n                  <sentinel-safe:z>+0000014.370</sentinel-safe:z>\n                </sentinel-safe:position>\n                <sentinel-safe:velocity>\n                  <sentinel-safe:x>+1541.463032</sentinel-safe:x>\n                  <sentinel-safe:y>+0562.236011</sentinel-safe:y>\n                  <sentinel-safe:z>+7366.402657</sentinel-safe:z>\n                </sentinel-safe:velocity>\n              </sentinel-safe:ephemeris>\n            </sentinel-safe:elementSet>\n          </sentinel-safe:orbitReference>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n          <sentinel-safe:orbitReference>\n            <sentinel-safe:orbitNumber groundTrackDirection=\"descending\" type=\"start\">60627</sentinel-safe:orbitNumber>\n            <sentinel-safe:relativeOrbitNumber groundTrackDirection=\"descending\" type=\"start\">182</sentinel-safe:relativeOrbitNumber>\n            <sentinel-safe:passNumber groundTrackDirection=\"descending\" type=\"start\">121254</sentinel-safe:passNumber>\n            <sentinel-safe:relativePassNumber groundTrackDirection=\"descending\" type=\"start\">364</sentinel-safe:relativePassNumber>\n            <sentinel-safe:cycleNumber>158</sentinel-safe:cycleNumber>\n            <sentinel-safe:phaseIdentifier>1</sentinel-safe:phaseIdentifier>\n            <sentinel-safe:elementSet>\n              <sentinel-safe:ephemeris>\n                <sentinel-safe:epoch type=\"UTC\">2013-07-07T14:38:40.174945Z</sentinel-safe:epoch>\n                <sentinel-safe:epoch type=\"UT1\">2013-07-07T14:38:40.233437</sentinel-safe:epoch>\n                <sentinel-safe:epoch type=\"TAI\">2013-07-07T14:39:15.174945</sentinel-safe:epoch>\n                <sentinel-safe:position>\n                  <sentinel-safe:x>-2496716.548</sentinel-safe:x>\n                  <sentinel-safe:y>+6735891.009</sentinel-safe:y>\n                  <sentinel-safe:z>+0000014.370</sentinel-safe:z>\n                </sentinel-safe:position>\n                <sentinel-safe:velocity>\n                  <sentinel-safe:x>+1541.463032</sentinel-safe:x>\n                  <sentinel-safe:y>+0562.236011</sentinel-safe:y>\n                  <sentinel-safe:z>+7366.402657</sentinel-safe:z>\n                </sentinel-safe:velocity>\n              </sentinel-safe:ephemeris>\n            </sentinel-safe:elementSet>\n          </sentinel-safe:orbitReference>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("sentinel-safe:orbitReference");
        manifest.appendChild(manifestElement);
        new OrbitReferenceMerger().mergeNodes(fromParents, manifestElement, manifest);
        for (Node fromParent : fromParents) {
            this.assertEqualsElement(fromParent, manifestElement);
        }
    }

    private void assertEqualsElement(Node expected, Node actual) {
        TestCase.assertEquals((String)expected.getNodeName(), (String)actual.getNodeName());
        TestCase.assertEquals((int)0, (int)actual.getAttributes().getLength());
        NodeList expectedChildNodes = expected.getChildNodes();
        NodeList actualChildNodes = actual.getChildNodes();
        TestCase.assertEquals((int)7, (int)actualChildNodes.getLength());
        for (int i = 0; i < actualChildNodes.getLength(); ++i) {
            Node expectedItem = expectedChildNodes.item(2 * i + 1);
            Node actualItem = actualChildNodes.item(i);
            TestCase.assertEquals((String)expectedItem.getNodeName(), (String)actualItem.getNodeName());
            TestCase.assertEquals((String)expectedItem.getNodeValue(), (String)actualItem.getNodeValue());
            NamedNodeMap expectedAttributes = expectedItem.getAttributes();
            NamedNodeMap actualAttributes = actualItem.getAttributes();
            TestCase.assertEquals((int)expectedAttributes.getLength(), (int)actualAttributes.getLength());
            for (int j = 0; j < expectedAttributes.getLength(); ++j) {
                Node expectedAttribute = expectedAttributes.item(j);
                Node actualAttribute = actualAttributes.getNamedItem(expectedAttribute.getNodeName());
                Assert.assertNotNull((Object)actualAttribute);
                TestCase.assertEquals((String)expectedAttribute.getNodeValue(), (String)actualAttribute.getNodeValue());
            }
        }
    }
}

