/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.TestUtils;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ManifestMergerTest {
    private File targetDirectory;
    private Document manifest;
    private ManifestMerger manifestMerger;

    @Before
    public void setUp() {
        this.targetDirectory = new File("test_out");
        if (!this.targetDirectory.mkdirs()) {
            Assert.fail((String)"Unable to create test target directory");
        }
        this.manifestMerger = new ManifestMerger();
        try {
            this.manifest = ManifestTestUtils.createDocument();
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        if (this.targetDirectory.isDirectory() && !FileUtils.deleteTree((File)this.targetDirectory)) {
            Assert.fail((String)"Unable to delete test directory");
        }
    }

    @Test
    public void testMergeManifests_OneFile() throws IOException, ParserConfigurationException, TransformerException, PDUStitchingException {
        File inputManifest = ManifestMergerTest.getManifestFile(TestUtils.FIRST_FILE_NAME);
        Date now = Calendar.getInstance().getTime();
        File productDir = new File(ManifestMergerTest.class.getResource("").getFile());
        File manifestFile = this.manifestMerger.createMergedManifest(new File[]{inputManifest}, now, productDir, 5000L);
    }

    @Test
    public void testMergeManifests_MultipleFiles() throws IOException, ParserConfigurationException, TransformerException, PDUStitchingException {
        Date now = Calendar.getInstance().getTime();
        File productDir = new File(ManifestMergerTest.class.getResource("").getFile());
        File manifestFile = this.manifestMerger.createMergedManifest(ManifestMergerTest.getManifestFiles(), now, productDir, 5000L);
    }

    @Test
    @Ignore
    public void testMergeSentinelSafeProcessingNodes() throws IOException, ParserConfigurationException, SAXException, PDUStitchingException {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n          <sentinel-safe:processing name=\"DataProcessing\" outputLevel=\"1\" start=\"2015-02-17T18:35:19.139217Z\" stop=\"2015-02-17T18:58:46.896371Z\">\n          </sentinel-safe:processing>"));
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                    <sentinel-safe:processing name=\"DataProcessing\" outputLevel=\"1\" start=\"2015-02-17T18:35:18.291550Z\" stop=\"2015-02-17T18:58:57.569852Z\">\n          </sentinel-safe:processing>"));
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n          <sentinel-safe:processing name=\"DataProcessing\" outputLevel=\"1\" start=\"2015-02-17T18:35:25.916879Z\" stop=\"2015-02-17T18:58:50.564464Z\">\n          </sentinel-safe:processing>"));
        Element manifestElement = this.manifest.createElement("sentinel-safe:processing");
        this.manifest.appendChild(manifestElement);
        NamedNodeMap manifestElementAttributes = manifestElement.getFirstChild().getAttributes();
        TestCase.assertEquals((int)4, (int)manifestElementAttributes.getLength());
        junit.framework.Assert.assertNotNull((Object)manifestElementAttributes.getNamedItem("name"));
        TestCase.assertEquals((String)"DataProcessing", (String)manifestElementAttributes.getNamedItem("name").getNodeValue());
        junit.framework.Assert.assertNotNull((Object)manifestElementAttributes.getNamedItem("outputLevel"));
        TestCase.assertEquals((String)"1", (String)manifestElementAttributes.getNamedItem("outputLevel").getNodeValue());
        junit.framework.Assert.assertNotNull((Object)manifestElementAttributes.getNamedItem("start").getNodeValue());
        TestCase.assertEquals((String)"2015-02-17T18:35:18.291550Z", (String)manifestElementAttributes.getNamedItem("start").getNodeValue());
        junit.framework.Assert.assertNotNull((Object)manifestElementAttributes.getNamedItem("stop").getNodeValue());
        TestCase.assertEquals((String)"2015-02-17T18:58:57.569852Z", (String)manifestElementAttributes.getNamedItem("stop").getNodeValue());
    }

    private static File[] getManifestFiles() {
        return new File[]{ManifestMergerTest.getManifestFile(TestUtils.FIRST_FILE_NAME), ManifestMergerTest.getManifestFile(TestUtils.SECOND_FILE_NAME), ManifestMergerTest.getManifestFile(TestUtils.THIRD_FILE_NAME)};
    }

    private static File getManifestFile(String fileName) {
        String fullFileName = fileName + "/xfdumanifest.xml";
        URL resource = ManifestMergerTest.class.getResource(fullFileName);
        return new File(resource.getFile());
    }
}

